/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal;

import com.adobe.cq.wcm.core.components.models.ExperienceFragment;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.factory.ModelFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public class Utils {
    private static final Set<String> INTERNAL_PARAMETER = ImmutableSet.of((Object)":formstart", (Object)"_charset_", (Object)":redirect", (Object)":cq_csrf_token");
    public static final String COMPONENTS_SERVICE = "components-service";

    private Utils() {
    }

    @NotNull
    public static String getURL(@NotNull SlingHttpServletRequest request, @NotNull PageManager pageManager, @NotNull String path) {
        Page page = pageManager.getPage(path);
        if (page != null) {
            return Utils.getURL(request, page);
        }
        return path;
    }

    @NotNull
    public static String getURL(@NotNull SlingHttpServletRequest request, @NotNull Page page) {
        String vanityURL = page.getVanityUrl();
        return StringUtils.isEmpty((CharSequence)vanityURL) ? request.getContextPath() + page.getPath() + ".html" : request.getContextPath() + vanityURL;
    }

    @NotNull
    public static Set<String> getPageResourceTypes(@NotNull Page page, @NotNull SlingHttpServletRequest request, @NotNull ModelFactory modelFactory) {
        HashSet<String> resourceTypes = new HashSet<String>();
        resourceTypes.addAll(Utils.getResourceTypes(page.getContentResource(), request, modelFactory));
        resourceTypes.addAll(Utils.getTemplateResourceTypes(page, request, modelFactory));
        return resourceTypes;
    }

    @NotNull
    public static Set<String> getResourceTypes(@NotNull Resource resource, @NotNull SlingHttpServletRequest request, @NotNull ModelFactory modelFactory) {
        HashSet<String> resourceTypes = new HashSet<String>();
        resourceTypes.add(resource.getResourceType());
        resourceTypes.addAll(Utils.getXFResourceTypes(resource, request, modelFactory));
        for (Resource child : resource.getChildren()) {
            resourceTypes.addAll(Utils.getResourceTypes(child, request, modelFactory));
        }
        return resourceTypes;
    }

    @NotNull
    public static Set<String> getXFResourceTypes(@NotNull Resource resource, @NotNull SlingHttpServletRequest request, @NotNull ModelFactory modelFactory) {
        Resource fragmentResource;
        String fragmentPath;
        ExperienceFragment experienceFragment = (ExperienceFragment)modelFactory.getModelFromWrappedRequest(request, resource, ExperienceFragment.class);
        if (experienceFragment != null && StringUtils.isNotEmpty((CharSequence)(fragmentPath = experienceFragment.getLocalizedFragmentVariationPath())) && (fragmentResource = resource.getResourceResolver().getResource(fragmentPath)) != null) {
            return Utils.getResourceTypes(fragmentResource, request, modelFactory);
        }
        return Collections.emptySet();
    }

    @NotNull
    public static Set<String> getTemplateResourceTypes(@NotNull Page page, @NotNull SlingHttpServletRequest request, @NotNull ModelFactory modelFactory) {
        Template template = page.getTemplate();
        if (template != null) {
            String templatePath = template.getPath() + "/structure/jcr:content/";
            Resource templateResource = request.getResourceResolver().getResource(templatePath);
            if (templateResource != null) {
                return Utils.getResourceTypes(templateResource, request, modelFactory);
            }
        }
        return Collections.emptySet();
    }

    @NotNull
    public static Set<String> getSuperTypes(@NotNull String resourceType, @NotNull ResourceResolver resourceResolver) {
        HashSet<String> superTypes = new HashSet<String>();
        String superType = resourceType;
        while (superType != null) {
            if ((superType = (String)Optional.ofNullable(resourceResolver.getResource(superType)).map(Resource::getResourceSuperType).filter(StringUtils::isNotEmpty).orElse(null)) == null) continue;
            superTypes.add(superType);
        }
        return superTypes;
    }

    @NotNull
    public static Set<String> getStrings(@Nullable Object input) {
        LinkedHashSet<String> strings;
        block3: {
            Class<?> clazz;
            block5: {
                block4: {
                    strings = new LinkedHashSet<String>();
                    if (input == null) break block3;
                    clazz = input.getClass();
                    if (!Collection.class.isAssignableFrom(clazz)) break block4;
                    for (Object obj : (Collection)input) {
                        if (obj == null) continue;
                        strings.add(obj.toString());
                    }
                    break block3;
                }
                if (!Object[].class.isAssignableFrom(clazz)) break block5;
                for (Object obj : (Object[])input) {
                    if (obj == null) continue;
                    strings.add(obj.toString());
                }
                break block3;
            }
            if (!String.class.isAssignableFrom(clazz)) break block3;
            for (String str : ((String)input).split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)str)) continue;
                strings.add(str.trim());
            }
        }
        return strings;
    }

    public static JSONObject getJsonOfRequestParameters(SlingHttpServletRequest request) throws JSONException {
        JSONObject jsonObj = new JSONObject();
        Map params = request.getParameterMap();
        for (Map.Entry entry : params.entrySet()) {
            if (INTERNAL_PARAMETER.contains(entry.getKey())) continue;
            String[] v = (String[])entry.getValue();
            String[] o = v.length == 1 ? v[0] : v;
            jsonObj.put((String)entry.getKey(), (Object)o);
        }
        return jsonObj;
    }

    public static enum Heading {
        H1("h1"),
        H2("h2"),
        H3("h3"),
        H4("h4"),
        H5("h5"),
        H6("h6");

        private String element;

        private Heading(String element) {
            this.element = element;
        }

        public static Heading getHeading(String value) {
            for (Heading heading : Heading.values()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)heading.element, (CharSequence)value)) continue;
                return heading;
            }
            return null;
        }

        public String getElement() {
            return this.element;
        }
    }
}

