/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.ComponentDataBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.adobe.cq.wcm.core.components.util.ComponentUtils;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentContext;
import java.util.Calendar;
import java.util.Optional;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractComponentImpl
implements com.adobe.cq.wcm.core.components.models.Component {
    @SlingObject
    protected Resource resource;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    protected Component component;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    protected ComponentContext componentContext;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private Page currentPage;
    private String id;
    private Boolean dataLayerEnabled;
    private ComponentData componentData;

    @Override
    @NotNull
    public String getId() {
        if (this.id == null) {
            this.id = ComponentUtils.getId(this.resource, this.currentPage, this.componentContext);
        }
        return this.id;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.resource.getResourceType();
    }

    @Override
    @Nullable
    public ComponentData getData() {
        if (this.componentData == null) {
            if (this.dataLayerEnabled == null) {
                this.dataLayerEnabled = ComponentUtils.isDataLayerEnabled(this.resource);
            }
            if (this.dataLayerEnabled.booleanValue()) {
                this.componentData = this.getComponentData();
            }
        }
        return this.componentData;
    }

    @NotNull
    protected ComponentData getComponentData() {
        return ((ComponentDataBuilder)((ComponentDataBuilder)DataLayerBuilder.forComponent().withId(this::getId).withLastModifiedDate(() -> Optional.ofNullable(this.resource.getValueMap().get("jcr:lastModified", Calendar.class)).map(Calendar::getTime).orElseGet(() -> Optional.ofNullable(this.resource.getValueMap().get("jcr:created", Calendar.class)).map(Calendar::getTime).orElse(null)))).withType(() -> this.resource.getResourceType())).build();
    }
}

