/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.export.json.ContainerExporter;
import com.adobe.cq.wcm.core.components.internal.Utils;
import com.adobe.cq.wcm.core.components.internal.models.v1.PanelContainerImpl;
import com.adobe.cq.wcm.core.components.models.Accordion;
import com.adobe.cq.wcm.core.components.models.Component;
import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.day.cq.wcm.api.designer.Style;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Accordion.class, ComponentExporter.class, ContainerExporter.class}, resourceType={"core/wcm/components/accordion/v1/accordion"})
@Exporter(name="jackson", extensions={"json"})
public class AccordionImpl
extends PanelContainerImpl
implements Accordion {
    public static final String RESOURCE_TYPE = "core/wcm/components/accordion/v1/accordion";
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    private boolean singleExpansion;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String[] expandedItems;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String headingElement;
    @ScriptVariable
    private Style currentStyle;
    private String[] expandedItemNames;
    private String[] expandedItemIds;
    private Utils.Heading heading;

    @Override
    public boolean isSingleExpansion() {
        return this.singleExpansion;
    }

    @Override
    public String[] getExpandedItems() {
        if (this.expandedItemNames == null) {
            this.expandedItemNames = (String[])Optional.ofNullable(this.expandedItems).map(Arrays::stream).orElse(Stream.empty()).filter(Objects::nonNull).filter(item -> Objects.nonNull(this.resource.getChild(item))).toArray(String[]::new);
        }
        return Arrays.copyOf(this.expandedItemNames, this.expandedItemNames.length);
    }

    @Override
    public String getHeadingElement() {
        if (this.heading == null) {
            this.heading = Utils.Heading.getHeading(this.headingElement);
            if (this.heading == null) {
                this.heading = Utils.Heading.getHeading((String)this.currentStyle.get("headingElement", String.class));
            }
        }
        if (this.heading != null) {
            return this.heading.getElement();
        }
        return null;
    }

    @Override
    public String[] getDataLayerShownItems() {
        if (this.expandedItems == null) {
            return new String[0];
        }
        if (this.expandedItemIds == null) {
            List<String> expandedItemsName = Arrays.asList(this.expandedItems);
            this.expandedItemIds = (String[])this.getItems().stream().filter(item -> expandedItemsName.contains(item.getName())).map(Component::getData).filter(Objects::nonNull).map(ComponentData::getId).toArray(String[]::new);
        }
        return Arrays.copyOf(this.expandedItemIds, this.expandedItemIds.length);
    }
}

