/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.wcm.core.components.internal.Utils;
import com.adobe.cq.wcm.core.components.models.ClientLibraries;
import com.adobe.granite.ui.clientlibs.ClientLibrary;
import com.adobe.granite.ui.clientlibs.HtmlLibrary;
import com.adobe.granite.ui.clientlibs.HtmlLibraryManager;
import com.adobe.granite.ui.clientlibs.LibraryType;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={ClientLibraries.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class ClientLibrariesImpl
implements ClientLibraries {
    private static final Logger LOG = LoggerFactory.getLogger(ClientLibrariesImpl.class);
    public static final String COMPONENTS_SERVICE = "components-service";
    @Self
    private SlingHttpServletRequest request;
    @Inject
    @Named(value="resourceTypes")
    Object resourceTypes;
    @Inject
    @Named(value="filter")
    String filterRegex;
    @Inject
    @Named(value="inherited")
    @Default(booleanValues={true})
    boolean inherited;
    @Inject
    @Named(value="categories")
    private Object categories;
    @Inject
    @Named(value="async")
    @javax.annotation.Nullable
    private boolean async;
    @Inject
    @Named(value="defer")
    @javax.annotation.Nullable
    private boolean defer;
    @Inject
    @Named(value="crossorigin")
    @javax.annotation.Nullable
    private String crossorigin;
    @Inject
    @Named(value="onload")
    @javax.annotation.Nullable
    private String onload;
    @Inject
    @Named(value="media")
    @javax.annotation.Nullable
    private String media;
    @OSGiService
    private HtmlLibraryManager htmlLibraryManager;
    @OSGiService
    ResourceResolverFactory resolverFactory;
    private Set<String> resourceTypeSet;
    private Pattern pattern;
    private String[] categoriesArray;

    @PostConstruct
    protected void initModel() {
        Set<String> categoriesSet;
        this.resourceTypeSet = Utils.getStrings(this.resourceTypes);
        if (StringUtils.isNotEmpty((CharSequence)this.filterRegex)) {
            this.pattern = Pattern.compile(this.filterRegex);
        }
        if ((categoriesSet = Utils.getStrings(this.categories)).isEmpty()) {
            categoriesSet = this.getCategoriesFromComponents();
        }
        this.categoriesArray = categoriesSet.toArray(new String[0]);
    }

    @Override
    @NotNull
    public String getJsInline() {
        return this.getInline(LibraryType.JS);
    }

    @Override
    @NotNull
    public String getCssInline() {
        return this.getInline(LibraryType.CSS);
    }

    @Override
    public String getJsIncludes() {
        return this.getLibIncludes(LibraryType.JS);
    }

    @Override
    public String getCssIncludes() {
        return this.getLibIncludes(LibraryType.CSS);
    }

    @Override
    public String getJsAndCssIncludes() {
        return this.getLibIncludes(null);
    }

    private String getLibIncludes(LibraryType type) {
        StringWriter sw = new StringWriter();
        try {
            if (this.categoriesArray == null || this.categoriesArray.length == 0) {
                LOG.error("No categories detected. Please either specify the categories as a CSV string or a set of resource types for looking them up!");
            } else {
                PrintWriter out = new PrintWriter(sw);
                if (type == LibraryType.JS) {
                    this.htmlLibraryManager.writeJsInclude(this.request, (Writer)out, this.categoriesArray);
                } else if (type == LibraryType.CSS) {
                    this.htmlLibraryManager.writeCssInclude(this.request, (Writer)out, this.categoriesArray);
                } else {
                    this.htmlLibraryManager.writeIncludes(this.request, (Writer)out, this.categoriesArray);
                }
            }
        }
        catch (IOException e) {
            LOG.error("Failed to include client libraries {}", (Object)Arrays.toString(this.categoriesArray));
        }
        String html = sw.toString();
        return this.getHtmlWithInjectedAttributes(html);
    }

    private String getHtmlWithInjectedAttributes(String html) {
        StringBuilder jsAttributes = new StringBuilder();
        jsAttributes.append(this.getHtmlAttr("async", this.async));
        jsAttributes.append(this.getHtmlAttr("defer", this.defer));
        jsAttributes.append(this.getHtmlAttr("crossorigin", this.crossorigin));
        jsAttributes.append(this.getHtmlAttr("onload", this.onload));
        StringBuilder cssAttributes = new StringBuilder();
        cssAttributes.append(this.getHtmlAttr("media", this.media));
        String updatedHtml = StringUtils.replace((String)html, (String)"<script ", (String)("<script " + jsAttributes.toString()));
        return StringUtils.replace((String)updatedHtml, (String)"<link ", (String)("<link " + cssAttributes.toString()));
    }

    private String getHtmlAttr(String name, boolean include) {
        if (include) {
            return name + " ";
        }
        return "";
    }

    private String getHtmlAttr(String name, String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return name + "=\"" + value + "\" ";
        }
        return "";
    }

    private String getInline(LibraryType libraryType) {
        Collection clientlibs = this.htmlLibraryManager.getLibraries(this.categoriesArray, libraryType, true, false);
        StringBuilder output = new StringBuilder();
        for (ClientLibrary clientlib : clientlibs) {
            HtmlLibrary htmlLibrary = this.htmlLibraryManager.getLibrary(libraryType, clientlib.getPath());
            if (htmlLibrary == null) continue;
            try {
                output.append(IOUtils.toString((InputStream)htmlLibrary.getInputStream(this.htmlLibraryManager.isMinifyEnabled()), (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                LOG.error("Error getting input stream from clientlib with path '{}'.", (Object)clientlib.getPath());
            }
        }
        return output.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected Set<String> getCategoriesFromComponents() {
        try (ResourceResolver resourceResolver = this.resolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", COMPONENTS_SERVICE));){
            HashSet<String> categories = new HashSet<String>();
            for (ClientLibrary library : this.getAllClientLibraries(resourceResolver)) {
                for (String category : library.getCategories()) {
                    if (this.pattern != null && !this.pattern.matcher(category).matches()) continue;
                    categories.add(category);
                }
            }
            HashSet<String> hashSet = categories;
            return hashSet;
        }
        catch (LoginException e) {
            LOG.error("Cannot login as a service user", (Throwable)e);
            return Collections.emptySet();
        }
    }

    @NotNull
    private Set<ClientLibrary> getAllClientLibraries(@NotNull ResourceResolver resourceResolver) {
        Map allLibraries = this.htmlLibraryManager.getLibraries();
        LinkedHashSet<ClientLibrary> clientLibraries = new LinkedHashSet<ClientLibrary>();
        for (String resourceType : this.getAllResourceTypes(resourceResolver)) {
            Resource resource = resourceResolver.getResource(resourceType);
            if (resource == null) continue;
            clientLibraries.addAll(ClientLibrariesImpl.getClientLibraries(resource, allLibraries));
        }
        return clientLibraries;
    }

    @NotNull
    private Set<String> getAllResourceTypes(@NotNull ResourceResolver resourceResolver) {
        LinkedHashSet<String> allResourceTypes = new LinkedHashSet<String>(this.resourceTypeSet);
        if (this.inherited) {
            for (String resourceType : this.resourceTypeSet) {
                allResourceTypes.addAll(Utils.getSuperTypes(resourceType, resourceResolver));
            }
        }
        return allResourceTypes;
    }

    @NotNull
    private static List<ClientLibrary> getClientLibraries(@Nullable Resource resource, @NotNull Map<String, ClientLibrary> allLibraries) {
        return Optional.ofNullable(resource).map(Resource::getPath).map(path -> allLibraries.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(path) || ((String)entry.getKey()).startsWith(path + "/")).map(Map.Entry::getValue).collect(Collectors.toList())).orElseGet(Collections::emptyList);
    }
}

