/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.models.Embed;
import com.adobe.cq.wcm.core.components.services.embed.UrlProcessor;
import com.day.cq.wcm.api.designer.Style;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Embed.class, ComponentExporter.class}, resourceType={"core/wcm/components/embed/v1/embed"})
@Exporter(name="jackson", extensions={"json"})
public class EmbedImpl
implements Embed {
    protected static final String RESOURCE_TYPE = "core/wcm/components/embed/v1/embed";
    @ValueMapValue(name="type", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String type;
    @ValueMapValue(name="url", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String url;
    @ValueMapValue(name="html", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String html;
    @ValueMapValue(name="embeddableResourceType", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String embeddableResourceType;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private Style currentStyle;
    @Inject
    @Optional
    private List<UrlProcessor> urlProcessors;
    @Inject
    private Resource resource;
    private Embed.Type embedType;
    private UrlProcessor.Result result;

    @PostConstruct
    private void initModel() {
        this.embedType = Embed.Type.fromString(this.type);
        if (this.embedType == null || this.embedType != Embed.Type.URL) {
            this.url = null;
        }
        if (this.embedType == null || this.embedType != Embed.Type.HTML) {
            this.html = null;
        }
        if (this.embedType == null || this.embedType != Embed.Type.EMBEDDABLE) {
            this.embeddableResourceType = null;
        }
        if (this.currentStyle != null) {
            boolean urlDisabled = (Boolean)this.currentStyle.get("urlDisabled", (Object)false);
            boolean htmlDisabled = (Boolean)this.currentStyle.get("htmlDisabled", (Object)false);
            boolean embeddablesDisabled = (Boolean)this.currentStyle.get("embeddablesDisabled", (Object)false);
            if (urlDisabled) {
                this.url = null;
            }
            if (htmlDisabled) {
                this.html = null;
            }
            if (embeddablesDisabled) {
                this.embeddableResourceType = null;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)this.url) && this.urlProcessors != null) {
            for (UrlProcessor urlProcessor : this.urlProcessors) {
                UrlProcessor.Result result = urlProcessor.process(this.url);
                if (result == null) continue;
                this.result = result;
                break;
            }
        }
    }

    @Override
    @Nullable
    public Embed.Type getType() {
        return this.embedType;
    }

    @Override
    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Override
    @Nullable
    public UrlProcessor.Result getResult() {
        return this.result;
    }

    @Override
    @Nullable
    public String getHtml() {
        return this.html;
    }

    @Override
    @Nullable
    public String getEmbeddableResourceType() {
        return this.embeddableResourceType;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.resource.getResourceType();
    }
}

