/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.export.json.ContainerExporter;
import com.adobe.cq.wcm.core.components.internal.ContentFragmentUtils;
import com.adobe.cq.wcm.core.components.models.ExperienceFragment;
import com.day.cq.wcm.api.LanguageManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.msm.api.LiveCopy;
import com.day.cq.wcm.msm.api.LiveRelationship;
import com.day.cq.wcm.msm.api.LiveRelationshipManager;
import com.day.text.Text;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jcr.RangeIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.apache.sling.models.factory.ModelFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL, adapters={ExperienceFragment.class, ComponentExporter.class, ContainerExporter.class}, resourceType={"core/wcm/components/experiencefragment/v1/experiencefragment"})
@Exporter(name="jackson", extensions={"json"})
public class ExperienceFragmentImpl
implements ExperienceFragment {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExperienceFragmentImpl.class);
    public static final String RESOURCE_TYPE_V1 = "core/wcm/components/experiencefragment/v1/experiencefragment";
    private static final String PATH_DELIMITER = "/";
    private static final char PATH_DELIMITER_CHAR = '/';
    private static final String CONTENT_ROOT = "/content";
    private static final String EXPERIENCE_FRAGMENTS_ROOT = "/content/experience-fragments";
    private static final String JCR_CONTENT_ROOT = "/jcr:content";
    private static final String CSS_EMPTY_CLASS = "empty";
    private static final String CSS_BASE_CLASS = "aem-xf";
    @Self
    private SlingHttpServletRequest request;
    @Inject
    protected Resource resource;
    @SlingObject
    private ResourceResolver resolver;
    @ScriptVariable
    @Nullable
    private Page currentPage;
    @ValueMapValue(name="fragmentVariationPath", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String fragmentVariationPath;
    @OSGiService
    private LanguageManager languageManager;
    @OSGiService
    private LiveRelationshipManager relationshipManager;
    @ValueMapValue(name="cq:cssClass")
    @Default(values={""})
    private String customCssClass;
    @Inject
    private ModelFactory modelFactory;
    private String localizedFragmentVariationPath;
    private String name;
    private String classNames = "aem-xf";
    private final Map<String, ComponentExporter> children = new HashMap<String, ComponentExporter>();

    @PostConstruct
    protected void initModel() {
        PageManager pageManager = (PageManager)this.resolver.adaptTo(PageManager.class);
        if (pageManager != null) {
            if (this.currentPage == null) {
                this.currentPage = pageManager.getContainingPage(this.resource);
            }
            if (this.currentPage != null) {
                this.resolveLocalizedFragmentVariationPath();
                this.resolveName(pageManager);
                this.retrieveExperienceFragmentChildModels();
            } else {
                LOGGER.error("Could not resolve currentPage!");
            }
        }
        this.appendCssClassNames();
    }

    @Override
    public String getLocalizedFragmentVariationPath() {
        return this.localizedFragmentVariationPath;
    }

    @Override
    @JsonIgnore
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.request.getResource().getResourceType();
    }

    @Override
    @Nonnull
    public Map<String, ? extends ComponentExporter> getExportedItems() {
        return this.children;
    }

    @Override
    @Nonnull
    public String[] getExportedItemsOrder() {
        return this.children.isEmpty() ? new String[]{} : this.children.keySet().toArray(new String[this.children.size()]);
    }

    @Override
    @JsonProperty(value="classNames")
    public String getCssClassNames() {
        return this.classNames;
    }

    @Override
    @JsonInclude
    public boolean isConfigured() {
        return StringUtils.isNotEmpty((CharSequence)this.localizedFragmentVariationPath) && !this.children.isEmpty();
    }

    private void resolveLocalizedFragmentVariationPath() {
        if (this.inTemplate() && this.currentPage != null) {
            String pagePath = this.currentPage.getPath();
            String currentPageRootPath = this.getLocalizationRoot(pagePath);
            String xfRootPath = this.getXfLocalizationRoot(this.fragmentVariationPath, currentPageRootPath);
            if (StringUtils.isNotEmpty((CharSequence)currentPageRootPath) && StringUtils.isNotEmpty((CharSequence)xfRootPath)) {
                String xfRelativePath = StringUtils.substring((String)this.fragmentVariationPath, (int)xfRootPath.length());
                String localizedXfRootPath = StringUtils.replace((String)currentPageRootPath, (String)CONTENT_ROOT, (String)EXPERIENCE_FRAGMENTS_ROOT, (int)1);
                this.localizedFragmentVariationPath = StringUtils.join((Object[])new String[]{localizedXfRootPath, xfRelativePath, JCR_CONTENT_ROOT});
            }
        }
        String xfContentPath = StringUtils.join((Object[])new String[]{this.fragmentVariationPath, JCR_CONTENT_ROOT});
        if (!this.resourceExists(this.localizedFragmentVariationPath) && this.resourceExists(xfContentPath)) {
            this.localizedFragmentVariationPath = xfContentPath;
        }
        if (!this.isExperienceFragmentVariation(this.localizedFragmentVariationPath)) {
            this.localizedFragmentVariationPath = null;
        }
    }

    private String getLocalizationRoot(String path) {
        String root = null;
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            Resource resource = this.resolver.getResource(path);
            root = this.getLanguageRoot(resource);
            if (StringUtils.isEmpty((CharSequence)root)) {
                root = this.getBlueprintPath(resource);
            }
            if (StringUtils.isEmpty((CharSequence)root)) {
                root = this.getLiveCopyPath(resource);
            }
        }
        return root;
    }

    private String getLanguageRoot(Resource resource) {
        Page rootPage = this.languageManager.getLanguageRoot(resource);
        if (rootPage != null) {
            return rootPage.getPath();
        }
        return null;
    }

    private String getBlueprintPath(Resource resource) {
        try {
            LiveRelationship relationship;
            LiveCopy liveCopy;
            RangeIterator liveCopiesIterator;
            if (this.relationshipManager.isSource(resource) && (liveCopiesIterator = this.relationshipManager.getLiveRelationships(resource, null, null)) != null && (liveCopy = (relationship = (LiveRelationship)liveCopiesIterator.next()).getLiveCopy()) != null) {
                return liveCopy.getBlueprintPath();
            }
        }
        catch (WCMException e) {
            LOGGER.error("Unable to get the blueprint: {}", (Object)e.getMessage());
        }
        return null;
    }

    private String getLiveCopyPath(Resource resource) {
        try {
            LiveCopy liveCopy;
            LiveRelationship liveRelationship;
            if (this.relationshipManager.hasLiveRelationship(resource) && (liveRelationship = this.relationshipManager.getLiveRelationship(resource, false)) != null && (liveCopy = liveRelationship.getLiveCopy()) != null) {
                return liveCopy.getPath();
            }
        }
        catch (WCMException e) {
            LOGGER.error("Unable to get the live copy: {}", (Object)e.getMessage());
        }
        return null;
    }

    private String getXfLocalizationRoot(String xfPath, String currentPageRoot) {
        String[] referenceRootTokens;
        int xfRootDepth;
        String[] xfPathTokens;
        String xfRoot = null;
        if (StringUtils.isNotEmpty((CharSequence)xfPath) && StringUtils.isNotEmpty((CharSequence)currentPageRoot) && this.resolver.getResource(xfPath) != null && this.resolver.getResource(currentPageRoot) != null && (xfPathTokens = Text.explode((String)xfPath, (int)47)).length >= (xfRootDepth = (referenceRootTokens = Text.explode((String)currentPageRoot, (int)47)).length + 1)) {
            String[] xfRootTokens = new String[xfRootDepth];
            System.arraycopy(xfPathTokens, 0, xfRootTokens, 0, xfRootDepth);
            xfRoot = StringUtils.join((Object[])new String[]{PATH_DELIMITER, Text.implode((String[])xfRootTokens, (String)PATH_DELIMITER)});
        }
        return xfRoot;
    }

    private boolean resourceExists(String path) {
        return StringUtils.isNotEmpty((CharSequence)path) && this.resolver.getResource(path) != null;
    }

    private boolean inTemplate() {
        if (this.currentPage == null) {
            return false;
        }
        Template template = this.currentPage.getTemplate();
        return template != null && StringUtils.startsWith((CharSequence)this.resource.getPath(), (CharSequence)template.getPath());
    }

    private boolean isExperienceFragmentVariation(String path) {
        Resource resource;
        if (StringUtils.isNotEmpty((CharSequence)path) && (resource = this.resolver.getResource(path)) != null) {
            ValueMap properties = resource.getValueMap();
            String xfVariantType = (String)properties.get("cq:xfVariantType", String.class);
            return xfVariantType != null;
        }
        return false;
    }

    private void resolveName(PageManager pageManager) {
        Page xfPage;
        Page xfVariationPage = pageManager.getPage(this.fragmentVariationPath);
        if (xfVariationPage != null && (xfPage = xfVariationPage.getParent()) != null) {
            this.name = xfPage.getName();
        }
    }

    private void retrieveExperienceFragmentChildModels() {
        Resource experienceFragmentResource;
        if (StringUtils.isNotBlank((CharSequence)this.localizedFragmentVariationPath) && this.resourceExists(this.localizedFragmentVariationPath) && (experienceFragmentResource = this.resolver.getResource(this.localizedFragmentVariationPath)) != null) {
            Iterator experienceFragmentVariantChildResources = experienceFragmentResource.listChildren();
            Map<String, ComponentExporter> resolvedChildren = ContentFragmentUtils.getComponentExporters(experienceFragmentVariantChildResources, this.modelFactory, this.request);
            this.children.putAll(resolvedChildren);
        }
    }

    private void appendCssClassNames() {
        if (this.children.isEmpty()) {
            this.classNames = this.classNames + " empty";
        }
        this.classNames = this.classNames + (StringUtils.isNotEmpty((CharSequence)this.customCssClass) ? " " + this.customCssClass : "");
    }
}

