/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.wcm.core.components.internal.models.v1.NavigationItemImpl;
import com.adobe.cq.wcm.core.components.models.LanguageNavigationItem;
import com.adobe.cq.wcm.core.components.models.NavigationItem;
import com.adobe.cq.wcm.core.components.models.datalayer.PageData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.components.Component;
import java.util.List;
import java.util.Locale;
import org.apache.sling.api.SlingHttpServletRequest;
import org.jetbrains.annotations.NotNull;

public class LanguageNavigationItemImpl
extends NavigationItemImpl
implements LanguageNavigationItem {
    protected String title;
    protected Locale locale;
    protected String country;
    protected String language;

    public LanguageNavigationItemImpl(Page page, boolean active, SlingHttpServletRequest request, int level, List<NavigationItem> children, String title, String parentId, Component component) {
        super(page, active, request, level, children, parentId, component);
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = this.page.getLanguage(false);
        }
        return this.locale;
    }

    @Override
    public String getCountry() {
        if (this.country == null) {
            this.country = this.page.getLanguage(false).getCountry();
        }
        return this.country;
    }

    @Override
    public String getLanguage() {
        if (this.language == null) {
            this.language = this.page.getLanguage(false).toString().replace('_', '-');
        }
        return this.language;
    }

    @Override
    @NotNull
    protected final PageData getComponentData() {
        return DataLayerBuilder.extending(super.getComponentData()).asPage().withLanguage(this::getLanguage).build();
    }
}

