/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.internal.models.v1.AbstractComponentImpl;
import com.day.cq.search.Predicate;
import com.day.cq.search.SimpleSearch;
import com.day.cq.search.result.SearchResult;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.designer.Style;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={com.adobe.cq.wcm.core.components.models.List.class, ComponentExporter.class}, resourceType={"core/wcm/components/list/v1/list"})
@Exporter(name="jackson", extensions={"json"})
public class ListImpl
extends AbstractComponentImpl
implements com.adobe.cq.wcm.core.components.models.List {
    protected static final String RESOURCE_TYPE = "core/wcm/components/list/v1/list";
    private static final Logger LOGGER = LoggerFactory.getLogger(ListImpl.class);
    private static final String PN_SEARCH_LIMIT = "limit";
    private static final String PN_MAX_ITEMS = "maxItems";
    private static final String PN_CHILD_DEPTH = "childDepth";
    private static final String PN_SEARCH_QUERY = "query";
    private static final boolean SHOW_DESCRIPTION_DEFAULT = false;
    private static final boolean SHOW_MODIFICATION_DATE_DEFAULT = false;
    private static final boolean LINK_ITEMS_DEFAULT = false;
    private static final int SEARCH_LIMIT_DEFAULT = 100;
    private static final int CHILD_DEPTH_DEFAULT = 1;
    private static final String DATE_FORMAT_DEFAULT = "yyyy-MM-dd";
    private static final String TAGS_MATCH_ANY_VALUE = "any";
    private static final int MAX_ITEMS_DEFAULT = 0;
    @ScriptVariable
    private ValueMap properties;
    @ScriptVariable
    private Style currentStyle;
    @ScriptVariable
    private Page currentPage;
    private String dateFormatString;
    private boolean showDescription;
    private boolean showModificationDate;
    private boolean linkItems;
    private List<Page> listItems;

    @PostConstruct
    private void initModel() {
        this.showDescription = (Boolean)this.properties.get("showDescription", this.currentStyle.get("showDescription", (Object)false));
        this.showModificationDate = (Boolean)this.properties.get("showModificationDate", this.currentStyle.get("showModificationDate", (Object)false));
        this.linkItems = (Boolean)this.properties.get("linkItems", this.currentStyle.get("linkItems", (Object)false));
        this.dateFormatString = (String)this.properties.get("dateFormat", this.currentStyle.get("dateFormat", (Object)DATE_FORMAT_DEFAULT));
    }

    @Override
    @Deprecated
    public Collection<Page> getItems() {
        if (this.listItems == null) {
            this.listItems = this.getPages();
        }
        return this.listItems;
    }

    @Override
    @JsonProperty(value="linkItems")
    public boolean linkItems() {
        return this.linkItems;
    }

    @Override
    @JsonProperty(value="showDescription")
    public boolean showDescription() {
        return this.showDescription;
    }

    @Override
    @JsonProperty(value="showModificationDate")
    public boolean showModificationDate() {
        return this.showModificationDate;
    }

    @Override
    public String getDateFormatString() {
        return this.dateFormatString;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.resource.getResourceType();
    }

    @NotNull
    private Source getListType() {
        return Optional.ofNullable(Optional.ofNullable(this.properties.get("listFrom", String.class)).orElseGet(() -> Optional.ofNullable(this.currentStyle.get("listFrom", String.class)).orElse(null))).map(Source::fromString).orElse(Source.EMPTY);
    }

    protected List<Page> getPages() {
        int maxItems;
        Stream<Object> itemStream;
        switch (this.getListType()) {
            case STATIC: {
                itemStream = this.getStaticListItems();
                break;
            }
            case CHILDREN: {
                itemStream = this.getChildListItems();
                break;
            }
            case TAGS: {
                itemStream = this.getTagListItems();
                break;
            }
            case SEARCH: {
                itemStream = this.getSearchListItems();
                break;
            }
            default: {
                itemStream = Stream.empty();
            }
        }
        OrderBy orderBy = OrderBy.fromString((String)this.properties.get("orderBy", (Object)""));
        if (orderBy != null) {
            SortOrder sortOrder = SortOrder.fromString((String)this.properties.get("sortOrder", (Object)SortOrder.ASC.value));
            itemStream = itemStream.sorted(new ListSort(orderBy, sortOrder, this.currentPage.getLanguage()));
        }
        if ((maxItems = ((Integer)this.properties.get(PN_MAX_ITEMS, (Object)0)).intValue()) != 0) {
            itemStream = itemStream.limit(maxItems);
        }
        return itemStream.collect(Collectors.toList());
    }

    private Stream<Page> getStaticListItems() {
        return Arrays.stream((Object[])this.properties.get("pages", (Object)new String[0])).map(arg_0 -> ((PageManager)this.currentPage.getPageManager()).getContainingPage(arg_0)).filter(Objects::nonNull);
    }

    private Stream<Page> getChildListItems() {
        int childDepth = (Integer)this.properties.get(PN_CHILD_DEPTH, (Object)1);
        return this.getRootPage("parentPage").map(rootPage -> ListImpl.collectChildren(childDepth, rootPage)).orElseGet(Stream::empty);
    }

    private static Stream<Page> collectChildren(int depth, @NotNull Page parent) {
        if (depth <= 0) {
            return Stream.empty();
        }
        Iterator childIterator = parent.listChildren();
        return StreamSupport.stream(((Iterable)() -> childIterator).spliterator(), false).flatMap(child -> Stream.concat(Stream.of(child), ListImpl.collectChildren(depth - 1, child)));
    }

    private Stream<Page> getTagListItems() {
        boolean matchAny = ((String)this.properties.get("tagsMatch", (Object)TAGS_MATCH_ANY_VALUE)).equals(TAGS_MATCH_ANY_VALUE);
        return Optional.ofNullable(this.properties.get("tags", String[].class)).filter(ArrayUtils::isNotEmpty).flatMap(tags -> this.getRootPage("tagsSearchRoot").flatMap(rootPage -> Optional.ofNullable(this.resource.getResourceResolver().adaptTo(TagManager.class)).map(tagManager -> tagManager.find(rootPage.getPath(), tags, matchAny)).map(iterator -> StreamSupport.stream(((Iterable)() -> iterator).spliterator(), false).map(arg_0 -> ((PageManager)this.currentPage.getPageManager()).getContainingPage(arg_0)).filter(Objects::nonNull)))).orElseGet(Stream::empty);
    }

    private Stream<Page> getSearchListItems() {
        SimpleSearch search;
        Optional<Page> searchRoot = this.getRootPage("searchIn");
        String query = (String)this.properties.get(PN_SEARCH_QUERY, String.class);
        if (!StringUtils.isBlank((CharSequence)query) && searchRoot.isPresent() && (search = (SimpleSearch)this.resource.adaptTo(SimpleSearch.class)) != null) {
            search.setQuery(query);
            search.setSearchIn(searchRoot.get().getPath());
            search.addPredicate(new Predicate("type", "type").set("type", "cq:Page"));
            int limit = (Integer)this.properties.get(PN_SEARCH_LIMIT, (Object)100);
            search.setHitsPerPage((long)limit);
            return this.safeGetSearchResult(search).map(SearchResult::getResources).map(it -> () -> it).map(it -> StreamSupport.stream(it.spliterator(), false)).orElseGet(Stream::empty).filter(Objects::nonNull).map(arg_0 -> ((PageManager)this.currentPage.getPageManager()).getContainingPage(arg_0)).filter(Objects::nonNull);
        }
        return Stream.empty();
    }

    @NotNull
    private Optional<SearchResult> safeGetSearchResult(@NotNull SimpleSearch search) {
        try {
            return Optional.of(search.getResult());
        }
        catch (RepositoryException e) {
            LOGGER.error("Unable to retrieve search results for query.", (Throwable)e);
            return Optional.empty();
        }
    }

    @NotNull
    private Optional<Page> getRootPage(@NotNull String fieldName) {
        Optional<String> parentPath = Optional.ofNullable(this.properties.get(fieldName, String.class)).filter(StringUtils::isNotBlank);
        if (!parentPath.isPresent()) {
            return Optional.of(this.currentPage);
        }
        return parentPath.map(arg_0 -> ((ResourceResolver)this.resource.getResourceResolver()).getResource(arg_0)).map(arg_0 -> ((PageManager)this.currentPage.getPageManager()).getContainingPage(arg_0));
    }

    private static class ListSort
    implements Comparator<Page>,
    Serializable {
        private static final long serialVersionUID = 1171225002657014881L;
        @Nullable
        private final SortOrder sortOrder;
        @Nullable
        private final OrderBy orderBy;
        @NotNull
        private final Comparator<String> titleComparator;

        ListSort(@Nullable OrderBy orderBy, @Nullable SortOrder sortOrder, @NotNull Locale locale) {
            this.orderBy = orderBy;
            this.sortOrder = sortOrder;
            Collator collator = Collator.getInstance(locale);
            collator.setStrength(0);
            this.titleComparator = Comparator.nullsLast(collator);
        }

        @Override
        public int compare(@NotNull Page item1, @NotNull Page item2) {
            int i = 0;
            if (this.orderBy == OrderBy.MODIFIED) {
                i = ObjectUtils.compare((Comparable)item1.getLastModified(), (Comparable)item2.getLastModified(), (boolean)true);
            } else if (this.orderBy == OrderBy.TITLE) {
                i = this.titleComparator.compare(item1.getTitle(), item2.getTitle());
            }
            if (this.sortOrder == SortOrder.DESC) {
                i *= -1;
            }
            return i;
        }
    }

    private static enum OrderBy {
        TITLE("title"),
        MODIFIED("modified");

        private final String value;

        private OrderBy(String value) {
            this.value = value;
        }

        @Nullable
        public static OrderBy fromString(String value) {
            for (OrderBy s : OrderBy.values()) {
                if (!StringUtils.equals((CharSequence)value, (CharSequence)s.value)) continue;
                return s;
            }
            return null;
        }
    }

    private static enum SortOrder {
        ASC("asc"),
        DESC("desc");

        private final String value;

        private SortOrder(String value) {
            this.value = value;
        }

        @NotNull
        public static SortOrder fromString(String value) {
            for (SortOrder s : SortOrder.values()) {
                if (!StringUtils.equals((CharSequence)value, (CharSequence)s.value)) continue;
                return s;
            }
            return ASC;
        }
    }

    protected static enum Source {
        CHILDREN("children"),
        STATIC("static"),
        SEARCH("search"),
        TAGS("tags"),
        EMPTY("");

        private final String value;

        private Source(String value) {
            this.value = value;
        }

        @Nullable
        public static Source fromString(String value) {
            for (Source s : Source.values()) {
                if (!StringUtils.equals((CharSequence)value, (CharSequence)s.value)) continue;
                return s;
            }
            return null;
        }
    }
}

