/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.internal.models.v1.AbstractComponentImpl;
import com.adobe.cq.wcm.core.components.internal.models.v1.NavigationItemImpl;
import com.adobe.cq.wcm.core.components.models.Navigation;
import com.adobe.cq.wcm.core.components.models.NavigationItem;
import com.day.cq.commons.Filter;
import com.day.cq.wcm.api.LanguageManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageFilter;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.msm.api.LiveRelationship;
import com.day.cq.wcm.msm.api.LiveRelationshipManager;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Navigation.class, ComponentExporter.class}, resourceType={"core/wcm/components/navigation/v1/navigation"})
@Exporter(name="jackson", extensions={"json"})
public class NavigationImpl
extends AbstractComponentImpl
implements Navigation {
    public static final String RESOURCE_TYPE = "core/wcm/components/navigation/v1/navigation";
    private static final String PN_ACCESSIBILITY_LABEL = "accessibilityLabel";
    @Self
    private SlingHttpServletRequest request;
    @ScriptVariable
    private Page currentPage;
    @ScriptVariable
    private Style currentStyle;
    @OSGiService
    private LanguageManager languageManager;
    @OSGiService
    private LiveRelationshipManager relationshipManager;
    @Nullable
    private String accessibilityLabel;
    private int structureStart;
    private int structureDepth;
    private Page navigationRootPage;
    private boolean isShadowingDisabled;
    private List<NavigationItem> items;

    @PostConstruct
    private void initModel() {
        boolean skipNavigationRoot;
        ValueMap properties = this.resource.getValueMap();
        this.structureDepth = (Integer)properties.get("structureDepth", this.currentStyle.get("structureDepth", (Object)-1));
        boolean collectAllPages = (Boolean)properties.get("collectAllPages", this.currentStyle.get("collectAllPages", (Object)true));
        if (collectAllPages) {
            this.structureDepth = -1;
        }
        this.structureStart = this.currentStyle.containsKey((Object)"structureStart") || properties.containsKey((Object)"structureStart") ? (Integer)properties.get("structureStart", this.currentStyle.get("structureStart", (Object)1)) : ((skipNavigationRoot = ((Boolean)properties.get("skipNavigationRoot", this.currentStyle.get("skipNavigationRoot", (Object)true))).booleanValue()) ? 1 : 0);
        this.isShadowingDisabled = (Boolean)properties.get("disableShadowing", this.currentStyle.get("disableShadowing", (Object)false));
    }

    private Page getNavigationRoot() {
        if (this.navigationRootPage == null) {
            String navigationRootPath = Optional.ofNullable(this.resource.getValueMap().get("navigationRoot", String.class)).orElseGet(() -> (String)this.currentStyle.get("navigationRoot", String.class));
            PageManager pageManager = this.currentPage.getPageManager();
            Page rootPage = pageManager.getPage(navigationRootPath);
            if (rootPage != null) {
                Page navigationRootLanguageRoot = this.getPageResource(rootPage).map(arg_0 -> ((LanguageManager)this.languageManager).getLanguageRoot(arg_0)).orElse(null);
                Page currentPageLanguageRoot = this.languageManager.getLanguageRoot(this.currentPage.getContentResource());
                if (navigationRootLanguageRoot != null && currentPageLanguageRoot != null && !navigationRootLanguageRoot.equals(currentPageLanguageRoot)) {
                    Page languageCopyNavigationRoot = pageManager.getPage(ResourceUtil.normalize((String)(currentPageLanguageRoot.getPath() + "/" + this.getRelativePath(navigationRootLanguageRoot, rootPage))));
                    if (languageCopyNavigationRoot != null) {
                        rootPage = languageCopyNavigationRoot;
                    }
                } else {
                    try {
                        String currentPagePath = this.currentPage.getPath() + "/";
                        rootPage = Optional.ofNullable(this.relationshipManager.getLiveRelationships((Resource)rootPage.adaptTo(Resource.class), null, null)).map(liveRelationshipIterator -> StreamSupport.stream(((Iterable)() -> liveRelationshipIterator).spliterator(), false)).orElseGet(Stream::empty).map(LiveRelationship::getTargetPath).filter(target -> currentPagePath.startsWith(target + "/")).map(arg_0 -> ((PageManager)pageManager).getPage(arg_0)).findFirst().orElse(rootPage);
                    }
                    catch (WCMException wCMException) {
                        // empty catch block
                    }
                }
            }
            this.navigationRootPage = rootPage;
        }
        return this.navigationRootPage;
    }

    @Override
    public List<NavigationItem> getItems() {
        if (this.items == null) {
            this.items = Optional.ofNullable(this.getNavigationRoot()).map(navigationRoot -> this.getRootItems((Page)navigationRoot, this.structureStart)).orElseGet(Stream::empty).map(item -> this.createNavigationItem((Page)item, this.getItems((Page)item))).collect(Collectors.toList());
        }
        return Collections.unmodifiableList(this.items);
    }

    @Override
    @Nullable
    public String getAccessibilityLabel() {
        if (this.accessibilityLabel == null) {
            this.accessibilityLabel = (String)this.resource.getValueMap().get(PN_ACCESSIBILITY_LABEL, String.class);
        }
        return this.accessibilityLabel;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.resource.getResourceType();
    }

    private List<NavigationItem> getItems(@NotNull Page subtreeRoot) {
        if (this.structureDepth < 0 || subtreeRoot.getDepth() - this.getNavigationRoot().getDepth() < this.structureDepth) {
            Iterator childIterator = subtreeRoot.listChildren((Filter)new PageFilter());
            return StreamSupport.stream(((Iterable)() -> childIterator).spliterator(), false).map(item -> this.createNavigationItem((Page)item, this.getItems((Page)item))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Stream<Page> getRootItems(@NotNull Page navigationRoot, int structureStart) {
        if (structureStart < 1) {
            return Stream.of(navigationRoot);
        }
        Iterator childIterator = navigationRoot.listChildren((Filter)new PageFilter());
        return StreamSupport.stream(((Iterable)() -> childIterator).spliterator(), false).flatMap(child -> this.getRootItems((Page)child, structureStart - 1));
    }

    private NavigationItemImpl createNavigationItem(@NotNull Page page, @NotNull List<NavigationItem> children) {
        int level = page.getDepth() - (this.getNavigationRoot().getDepth() + this.structureStart);
        boolean selected = this.checkSelected(page);
        return new NavigationItemImpl(page, selected, this.request, level, children, this.getId(), this.isShadowingDisabled, this.component);
    }

    private boolean checkSelected(@NotNull Page page) {
        return this.currentPage.equals(page) || this.currentPage.getPath().startsWith(page.getPath() + "/") || this.currentPageIsRedirectTarget(page);
    }

    private boolean currentPageIsRedirectTarget(@NotNull Page page) {
        return NavigationItemImpl.getRedirectTarget(page).filter(target -> target.equals(this.currentPage)).isPresent();
    }

    @Nullable
    private String getRelativePath(@NotNull Page root, @NotNull Page child) {
        if (child.equals(root)) {
            return ".";
        }
        if ((child.getPath() + "/").startsWith(root.getPath())) {
            return child.getPath().substring(root.getPath().length() + 1);
        }
        return null;
    }

    @NotNull
    final Optional<Resource> getPageResource(@NotNull Page page) {
        return Optional.ofNullable(Optional.of(page).map(Page::getContentResource).map(Resource::getParent).orElseGet(() -> this.resource.getResourceResolver().getResource(page.getPath())));
    }
}

