/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.internal.models.v1.AbstractComponentImpl;
import com.adobe.cq.wcm.core.components.internal.services.pdfviewer.PdfViewerCaConfig;
import com.adobe.cq.wcm.core.components.models.PdfViewer;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.ConfigurationBuilder;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={PdfViewer.class, ComponentExporter.class}, resourceType={"core/wcm/components/pdfviewer/v1/pdfviewer"})
@Exporter(name="jackson", extensions={"json"})
public class PdfViewerImpl
extends AbstractComponentImpl
implements PdfViewer {
    protected static final String RESOURCE_TYPE = "core/wcm/components/pdfviewer/v1/pdfviewer";
    protected static final String FIELD_EMBED_MODE = "embedMode";
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String documentPath;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String type;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String defaultViewMode;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    private boolean borderless;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    private boolean showAnnotationTools;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    private boolean showFullScreen;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    private boolean showLeftHandPanel;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    private boolean showDownloadPdf;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    private boolean showPrintPdf;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    private boolean showPageControls;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    private boolean dockPageControls;
    @Inject
    private Resource resource;
    private PdfViewerCaConfig caConfig;

    @PostConstruct
    protected void initModel() {
        ConfigurationBuilder cb = (ConfigurationBuilder)this.resource.adaptTo(ConfigurationBuilder.class);
        if (cb != null) {
            this.caConfig = (PdfViewerCaConfig)cb.as(PdfViewerCaConfig.class);
        }
    }

    @Override
    public String getClientId() {
        return this.caConfig.clientId();
    }

    @Override
    public String getReportSuiteId() {
        return this.caConfig.reportSuiteId();
    }

    @Override
    @Nullable
    public String getDocumentPath() {
        return this.documentPath;
    }

    @Override
    public String getDocumentFileName() {
        if (this.documentPath != null) {
            return StringUtils.substringAfterLast((String)this.documentPath, (String)"/");
        }
        return null;
    }

    @Override
    @Nullable
    public String getType() {
        return this.type;
    }

    @Override
    @Nullable
    public String getDefaultViewMode() {
        return this.defaultViewMode;
    }

    @Override
    public boolean isBorderless() {
        return this.borderless;
    }

    @Override
    public boolean isShowAnnotationTools() {
        return this.showAnnotationTools;
    }

    @Override
    public boolean isShowFullScreen() {
        return this.showFullScreen;
    }

    @Override
    public boolean isShowLeftHandPanel() {
        return this.showLeftHandPanel;
    }

    @Override
    public boolean isShowDownloadPdf() {
        return this.showDownloadPdf;
    }

    @Override
    public boolean isShowPrintPdf() {
        return this.showPrintPdf;
    }

    @Override
    public boolean isShowPageControls() {
        return this.showPageControls;
    }

    @Override
    public boolean isDockPageControls() {
        return this.dockPageControls;
    }

    @Override
    public String getViewerConfigJson() {
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add(FIELD_EMBED_MODE, this.type);
        if (StringUtils.equals((CharSequence)this.type, (CharSequence)"FULL_WINDOW")) {
            jsonObjectBuilder.add("defaultViewMode", this.defaultViewMode);
            jsonObjectBuilder.add("showAnnotationTools", this.showAnnotationTools);
            jsonObjectBuilder.add("showLeftHandPanel", this.showLeftHandPanel);
        }
        if (StringUtils.equals((CharSequence)this.type, (CharSequence)"SIZED_CONTAINER")) {
            jsonObjectBuilder.add("showFullScreen", this.showFullScreen);
        }
        if (StringUtils.equals((CharSequence)this.type, (CharSequence)"FULL_WINDOW") || StringUtils.equals((CharSequence)this.type, (CharSequence)"SIZED_CONTAINER")) {
            jsonObjectBuilder.add("showPageControls", this.showPageControls);
            jsonObjectBuilder.add("dockPageControls", this.dockPageControls);
        }
        jsonObjectBuilder.add("showDownloadPDF", this.showDownloadPdf);
        jsonObjectBuilder.add("showPrintPDF", this.showPrintPdf);
        return jsonObjectBuilder.build().toString();
    }

    @Override
    public String getContainerClass() {
        if (!StringUtils.isEmpty((CharSequence)this.type)) {
            if (this.type.equals("FULL_WINDOW") && this.borderless) {
                return "cmp-pdfviewer__full-window-borderless";
            }
            if (this.type.equals("SIZED_CONTAINER")) {
                return "cmp-pdfviewer__sized-container";
            }
            if (this.type.equals("IN_LINE")) {
                return "cmp-pdfviewer__in-line";
            }
        }
        return "cmp-pdfviewer__full-window";
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.resource.getResourceType();
    }
}

