/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.wcm.core.components.internal.Utils;
import com.adobe.cq.wcm.core.components.models.NavigationItem;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedirectItemImpl
implements NavigationItem {
    private String redirectTarget;
    private Page page;
    private String url;
    private SlingHttpServletRequest request;

    public RedirectItemImpl(@NotNull String redirectTarget, @NotNull SlingHttpServletRequest request) {
        this.redirectTarget = redirectTarget;
        this.request = request;
        this.page = this.getRedirectPage();
    }

    private Page getRedirectPage() {
        Page page = null;
        ResourceResolver resourceResolver = this.request.getResourceResolver();
        Resource targetResource = resourceResolver.getResource(this.redirectTarget);
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        if (pageManager != null && targetResource != null) {
            page = pageManager.getContainingPage(targetResource);
        }
        return page;
    }

    @Override
    @Deprecated
    @Nullable
    public Page getPage() {
        return this.page;
    }

    @Override
    @NotNull
    public String getURL() {
        if (this.url == null) {
            this.url = this.page != null ? Utils.getURL(this.request, this.page) : this.redirectTarget;
        }
        return this.url;
    }
}

