/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1.datalayer;

import com.adobe.cq.wcm.core.components.models.datalayer.AssetData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerSupplier;
import java.util.Arrays;
import java.util.Date;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class AssetDataImpl
implements AssetData {
    @NotNull
    private final DataLayerSupplier dataLayerSupplier;
    private String id;
    private Date lastModifiedDate;
    private String format;
    private String url;
    private String[] tags;

    public AssetDataImpl(@NotNull DataLayerSupplier supplier) {
        this.dataLayerSupplier = supplier;
    }

    @Override
    @NotNull
    public String getId() {
        if (this.id == null) {
            this.id = this.dataLayerSupplier.getId().get();
        }
        return this.id;
    }

    @Override
    public Date getLastModifiedDate() {
        if (this.lastModifiedDate == null) {
            this.lastModifiedDate = this.dataLayerSupplier.getLastModifiedDate().map(Supplier::get).orElse(null);
        }
        if (this.lastModifiedDate != null) {
            return new Date(this.lastModifiedDate.getTime());
        }
        return null;
    }

    @Override
    public String getFormat() {
        if (this.format == null) {
            this.format = this.dataLayerSupplier.getFormat().map(Supplier::get).orElse(null);
        }
        return this.format;
    }

    @Override
    public String getUrl() {
        if (this.url == null) {
            this.url = this.dataLayerSupplier.getUrl().map(Supplier::get).orElse(null);
        }
        return this.url;
    }

    @Override
    public String[] getTags() {
        if (this.tags == null) {
            this.tags = this.dataLayerSupplier.getTags().map(Supplier::get).orElse(null);
        }
        if (this.tags != null) {
            return Arrays.copyOf(this.tags, this.tags.length);
        }
        return null;
    }
}

