/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v2;

import com.adobe.cq.wcm.core.components.models.HtmlPageItem;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;

public class HtmlPageItemImpl
implements HtmlPageItem {
    String prefixPath;
    Resource resource;
    ValueMap properties;
    HtmlPageItem.Element element;
    HtmlPageItem.Location location;
    Map<String, String> attributes;

    public HtmlPageItemImpl(@NotNull String prefixPath, @NotNull Resource resource) {
        this.prefixPath = prefixPath;
        this.resource = resource;
        this.properties = resource.getValueMap();
    }

    @Override
    public HtmlPageItem.Element getElement() {
        if (this.element == null) {
            this.element = HtmlPageItem.Element.fromString((String)this.properties.get("element", String.class));
        }
        return this.element;
    }

    @Override
    public HtmlPageItem.Location getLocation() {
        if (this.location == null) {
            this.location = HtmlPageItem.Location.fromString((String)this.properties.get("location", String.class));
        }
        return this.location;
    }

    @Override
    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, String>();
            Resource attributesNode = this.resource.getChild("attributes");
            if (attributesNode != null) {
                ValueMap attributesProperties = attributesNode.getValueMap();
                for (String attrName : this.getElement().getAttributeNames()) {
                    String attrValue = (String)attributesProperties.get(attrName, String.class);
                    if (attrValue == null) continue;
                    if (this.getElement() == HtmlPageItem.Element.LINK && "href".equals(attrName) || this.getElement() == HtmlPageItem.Element.SCRIPT && "src".equals(attrName)) {
                        attrValue = this.prefixPath + attrValue;
                    }
                    this.attributes.put(attrName, attrValue);
                }
            }
        }
        return this.attributes;
    }
}

