/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v2;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.export.json.ContainerExporter;
import com.adobe.cq.wcm.core.components.config.HtmlPageItemsConfig;
import com.adobe.cq.wcm.core.components.internal.models.v1.RedirectItemImpl;
import com.adobe.cq.wcm.core.components.internal.models.v2.HtmlPageItemImpl;
import com.adobe.cq.wcm.core.components.models.HtmlPageItem;
import com.adobe.cq.wcm.core.components.models.NavigationItem;
import com.adobe.cq.wcm.core.components.models.Page;
import com.adobe.granite.license.ProductInfoProvider;
import com.adobe.granite.ui.clientlibs.ClientLibrary;
import com.adobe.granite.ui.clientlibs.HtmlLibraryManager;
import com.adobe.granite.ui.clientlibs.LibraryType;
import com.day.cq.wcm.api.components.ComponentContext;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.Version;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Page.class, ContainerExporter.class}, resourceType={"core/wcm/components/page/v2/page"})
@Exporter(name="jackson", extensions={"json"})
public class PageImpl
extends com.adobe.cq.wcm.core.components.internal.models.v1.PageImpl
implements Page {
    protected static final String RESOURCE_TYPE = "core/wcm/components/page/v2/page";
    protected static final String PN_CLIENTLIBS_JS_HEAD = "clientlibsJsHead";
    public static final String PN_REDIRECT_TARGET = "cq:redirectTarget";
    public static final String PN_MAIN_CONTENT_SELECTOR_PROP = "mainContentSelector";
    private Boolean hasCloudconfigSupport;
    @OSGiService
    private HtmlLibraryManager htmlLibraryManager;
    @OSGiService
    private ProductInfoProvider productInfoProvider;
    @OSGiService
    private ConfigurationResourceResolver configurationResourceResolver;
    @Self
    protected SlingHttpServletRequest request;
    @ScriptVariable
    private ComponentContext componentContext;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="cq:redirectTarget")
    @Nullable
    private String redirectTargetValue;
    private String appResourcesPath;
    private NavigationItem redirectTarget;
    private String[] clientLibCategoriesJsBody;
    private String[] clientLibCategoriesJsHead;
    private List<HtmlPageItem> htmlPageItems;

    @Override
    @PostConstruct
    protected void initModel() {
        super.initModel();
        this.appResourcesPath = Optional.ofNullable(this.currentStyle).map(style -> (String)style.get("appResourcesClientlib", String.class)).map(resourcesClientLibrary -> this.htmlLibraryManager.getLibraries(new String[]{resourcesClientLibrary}, LibraryType.CSS, true, false)).map(Collection::stream).orElse(Stream.empty()).findFirst().map(this::getProxyPath).orElse(null);
    }

    private String getProxyPath(ClientLibrary lib) {
        String path = lib.getPath();
        if (lib.allowProxy()) {
            for (String searchPath : this.request.getResourceResolver().getSearchPath()) {
                if (!path.startsWith(searchPath)) continue;
                path = this.request.getContextPath() + "/etc.clientlibs/" + path.replaceFirst(searchPath, "");
            }
        } else if (this.request.getResourceResolver().getResource(lib.getPath()) == null) {
            path = null;
        }
        if (path != null) {
            path = path + "/resources";
        }
        return path;
    }

    @Override
    protected void loadFavicons(String designPath) {
    }

    @Override
    @JsonIgnore
    @Deprecated
    public Map<String, String> getFavicons() {
        throw new UnsupportedOperationException();
    }

    @Override
    @JsonIgnore
    public String[] getClientLibCategoriesJsBody() {
        if (this.clientLibCategoriesJsBody == null) {
            List<String> headLibs = Arrays.asList(this.getClientLibCategoriesJsHead());
            this.clientLibCategoriesJsBody = (String[])Arrays.stream(this.clientLibCategories).distinct().filter(item -> !headLibs.contains(item)).toArray(String[]::new);
        }
        return Arrays.copyOf(this.clientLibCategoriesJsBody, this.clientLibCategoriesJsBody.length);
    }

    @Override
    @JsonIgnore
    public String[] getClientLibCategoriesJsHead() {
        if (this.clientLibCategoriesJsHead == null) {
            this.clientLibCategoriesJsHead = (String[])Optional.ofNullable(this.currentStyle).map(style -> (String[])style.get(PN_CLIENTLIBS_JS_HEAD, String[].class)).map(Arrays::stream).orElseGet(Stream::empty).distinct().toArray(String[]::new);
        }
        return Arrays.copyOf(this.clientLibCategoriesJsHead, this.clientLibCategoriesJsHead.length);
    }

    @Override
    public String getAppResourcesPath() {
        return this.appResourcesPath;
    }

    @Override
    public String getCssClassNames() {
        Set cssClassesSet = this.componentContext.getCssClassNames();
        return StringUtils.join((Iterable)cssClassesSet, (String)" ");
    }

    @Override
    @NotNull
    public String[] getExportedItemsOrder() {
        return super.getExportedItemsOrder();
    }

    @Override
    @NotNull
    public Map<String, ? extends ComponentExporter> getExportedItems() {
        return super.getExportedItems();
    }

    @Override
    @Nullable
    public NavigationItem getRedirectTarget() {
        if (this.redirectTarget == null && StringUtils.isNotEmpty((CharSequence)this.redirectTargetValue)) {
            this.redirectTarget = new RedirectItemImpl(this.redirectTargetValue, this.request);
        }
        return this.redirectTarget;
    }

    @Override
    public boolean hasCloudconfigSupport() {
        if (this.hasCloudconfigSupport == null) {
            this.hasCloudconfigSupport = this.productInfoProvider == null || this.productInfoProvider.getProductInfo() == null || this.productInfoProvider.getProductInfo().getVersion() == null ? Boolean.valueOf(false) : Boolean.valueOf(this.productInfoProvider.getProductInfo().getVersion().compareTo(new Version("6.4.0")) >= 0);
        }
        return this.hasCloudconfigSupport;
    }

    @Override
    public String getMainContentSelector() {
        if (this.currentStyle != null) {
            return (String)this.currentStyle.get(PN_MAIN_CONTENT_SELECTOR_PROP, String.class);
        }
        return null;
    }

    @Override
    @NotNull
    public List<HtmlPageItem> getHtmlPageItems() {
        if (this.htmlPageItems == null) {
            this.htmlPageItems = new LinkedList<HtmlPageItem>();
            Resource configResource = this.configurationResourceResolver.getResource(this.resource, "sling:configs", HtmlPageItemsConfig.class.getName());
            if (configResource != null) {
                ValueMap properties = configResource.getValueMap();
                for (Resource child : configResource.getChildren()) {
                    HtmlPageItemImpl item = new HtmlPageItemImpl((String)properties.get("prefixPath", (Object)""), child);
                    if (item.getElement() == null) continue;
                    this.htmlPageItems.add(item);
                }
            }
        }
        return this.htmlPageItems;
    }
}

