/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.resource;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.annotations.Exporter;
import org.jetbrains.annotations.NotNull;

@Exporter(name="jackson", extensions={"json"})
public class ImageResourceWrapper
extends ResourceWrapper {
    private ValueMap valueMap;
    private String resourceType;

    public ImageResourceWrapper(@NotNull Resource resource, @NotNull String resourceType) {
        super(resource);
        if (StringUtils.isEmpty((CharSequence)resourceType)) {
            throw new IllegalArgumentException("The " + ImageResourceWrapper.class.getName() + " needs to override the resource type of the wrapped resource, but the resourceType argument was null or empty.");
        }
        this.resourceType = resourceType;
        this.valueMap = new ValueMapDecorator(new HashMap(resource.getValueMap()));
        this.valueMap.put((Object)"sling:resourceType", (Object)resourceType);
    }

    public ImageResourceWrapper(@NotNull Resource resource, @NotNull String resourceType, List<String> hiddenProperties) {
        this(resource, resourceType);
        for (String property : hiddenProperties) {
            this.valueMap.remove((Object)property);
        }
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ValueMap.class) {
            return (AdapterType)this.valueMap;
        }
        return (AdapterType)super.adaptTo(type);
    }

    @NotNull
    public ValueMap getValueMap() {
        return this.valueMap;
    }

    @NotNull
    public String getResourceType() {
        return this.resourceType;
    }

    public boolean isResourceType(String resourceType) {
        return this.getResourceResolver().isResourceType((Resource)this, resourceType);
    }
}

