/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.services;

import com.adobe.cq.wcm.core.components.config.HtmlPageItemsConfig;
import com.adobe.cq.wcm.core.components.internal.DataLayerConfig;
import com.adobe.cq.wcm.core.components.internal.services.pdfviewer.PdfViewerCaConfig;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.reference.Reference;
import com.day.cq.wcm.api.reference.ReferenceProvider;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.osgi.service.component.annotations.Component;

@Component(service={ReferenceProvider.class})
public class CaConfigReferenceProvider
implements ReferenceProvider {
    private static final String CA_CONFIG_REFERENCE_TYPE = "caconfig";
    @org.osgi.service.component.annotations.Reference
    private ConfigurationResourceResolver configurationResourceResolver;

    public List<Reference> findReferences(Resource resource) {
        ArrayList<Reference> references = new ArrayList<Reference>();
        PageManager pageManager = (PageManager)resource.getResourceResolver().adaptTo(PageManager.class);
        if (pageManager == null) {
            return references;
        }
        Page page = pageManager.getContainingPage(resource);
        if (page == null) {
            return references;
        }
        this.addCaConfigReference(HtmlPageItemsConfig.class.getName(), resource, references);
        this.addCaConfigReference(DataLayerConfig.class.getName(), resource, references);
        this.addCaConfigReference(PdfViewerCaConfig.class.getName(), resource, references);
        return references;
    }

    private void addCaConfigReference(String configName, Resource resource, List<Reference> references) {
        Resource configResource = this.configurationResourceResolver.getResource(resource, "sling:configs", configName);
        if (configResource != null) {
            ValueMap properties = configResource.getValueMap();
            Calendar lastModified = (Calendar)properties.get("jcr:lastModified", Calendar.class);
            references.add(new Reference(CA_CONFIG_REFERENCE_TYPE, configName, configResource, lastModified != null ? lastModified.getTimeInMillis() : -1L));
        }
    }
}

