/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.services.embed;

import com.adobe.cq.wcm.core.components.internal.services.embed.UrlProcessorResultImpl;
import com.adobe.cq.wcm.core.components.services.embed.OEmbedClient;
import com.adobe.cq.wcm.core.components.services.embed.OEmbedResponse;
import com.adobe.cq.wcm.core.components.services.embed.UrlProcessor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={UrlProcessor.class})
public class OEmbedUrlProcessor
implements UrlProcessor {
    protected static final String NAME = "oembed";
    @Reference
    protected OEmbedClient oEmbedClient;

    @Override
    public UrlProcessor.Result process(String url) {
        if (this.oEmbedClient == null || StringUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        final String provider = this.oEmbedClient.getProvider(url);
        if (StringUtils.isEmpty((CharSequence)provider)) {
            return null;
        }
        final OEmbedResponse oEmbedResponse = this.oEmbedClient.getResponse(url);
        if (oEmbedResponse == null) {
            return null;
        }
        final boolean unsafeContext = this.oEmbedClient.isUnsafeContext(url);
        return new UrlProcessorResultImpl(NAME, (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("provider", provider);
                this.put("response", oEmbedResponse);
                this.put("unsafeContext", unsafeContext);
            }
        });
    }
}

