/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets;

import com.adobe.cq.wcm.core.components.internal.resource.ImageResourceWrapper;
import com.adobe.cq.wcm.core.components.internal.servlets.EnhancedRendition;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.RenditionPicker;
import com.day.cq.dam.api.handler.AssetHandler;
import com.day.cq.dam.api.handler.store.AssetStore;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentManager;
import com.day.cq.wcm.api.policies.ContentPolicy;
import com.day.cq.wcm.api.policies.ContentPolicyManager;
import com.day.cq.wcm.foundation.WCMRenditionPicker;
import com.day.image.Layer;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.mime.MimeTypeService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptiveImageServlet
extends SlingSafeMethodsServlet {
    public static final String DEFAULT_SELECTOR = "img";
    public static final String CORE_DEFAULT_SELECTOR = "coreimg";
    private static final String IMAGE_RESOURCE_TYPE = "core/wcm/components/image";
    static final int DEFAULT_RESIZE_WIDTH = 1280;
    public static final int DEFAULT_JPEG_QUALITY = 82;
    public static final int DEFAULT_MAX_SIZE = 3840;
    private static final Logger LOGGER = LoggerFactory.getLogger(AdaptiveImageServlet.class);
    private static final String DEFAULT_MIME = "image/jpeg";
    private static final String SELECTOR_QUALITY_KEY = "quality";
    private static final String SELECTOR_WIDTH_KEY = "width";
    private int defaultResizeWidth;
    private int maxInputWidth;
    @SuppressFBWarnings(justification="This field needs to be transient")
    private transient MimeTypeService mimeTypeService;
    @SuppressFBWarnings(justification="This field needs to be transient")
    private transient AssetStore assetStore;

    public AdaptiveImageServlet(MimeTypeService mimeTypeService, AssetStore assetStore, int defaultResizeWidth, int maxInputWidth) {
        this.mimeTypeService = mimeTypeService;
        this.assetStore = assetStore;
        this.defaultResizeWidth = defaultResizeWidth > 0 ? defaultResizeWidth : 1280;
        this.maxInputWidth = maxInputWidth > 0 ? maxInputWidth : 3840;
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        try {
            long requestLastModifiedSuffix;
            String imageName;
            RequestPathInfo requestPathInfo = request.getRequestPathInfo();
            List<String> selectorList = this.selectorToList(requestPathInfo.getSelectorString());
            String suffix = requestPathInfo.getSuffix();
            String string = imageName = StringUtils.isNotEmpty((CharSequence)suffix) ? FilenameUtils.getName((String)suffix) : "";
            if (StringUtils.isNotEmpty((CharSequence)suffix)) {
                String suffixExtension = FilenameUtils.getExtension((String)suffix);
                if (StringUtils.isNotEmpty((CharSequence)suffixExtension)) {
                    if (!suffixExtension.equals(requestPathInfo.getExtension())) {
                        LOGGER.error("The suffix part defines a different extension than the request: {}.", (Object)suffix);
                        response.sendError(404);
                        return;
                    }
                } else {
                    LOGGER.error("Invalid suffix: {}.", (Object)suffix);
                    response.sendError(404);
                    return;
                }
            }
            Resource component = request.getResource();
            ResourceResolver resourceResolver = request.getResourceResolver();
            if (!component.isResourceType(IMAGE_RESOURCE_TYPE)) {
                Template template;
                Page page;
                Resource componentCandidate = null;
                PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
                if (pageManager != null && (page = pageManager.getContainingPage(component)) != null && (template = page.getTemplate()) != null && StringUtils.isNotEmpty((CharSequence)suffix)) {
                    long lastModifiedSuffix = this.getRequestLastModifiedSuffix(suffix);
                    String relativeTemplatePath = lastModifiedSuffix == 0L ? suffix.substring(0, suffix.lastIndexOf(46)) : suffix.substring(0, suffix.lastIndexOf("/" + String.valueOf(lastModifiedSuffix)));
                    String imagePath = ResourceUtil.normalize((String)(template.getPath() + relativeTemplatePath));
                    if (StringUtils.isNotEmpty((CharSequence)imagePath) && !template.getPath().equals(imagePath)) {
                        componentCandidate = resourceResolver.getResource(imagePath);
                    }
                }
                if (componentCandidate == null) {
                    LOGGER.error("Unable to retrieve an image from this page's template.");
                    response.sendError(404);
                    return;
                }
                component = componentCandidate;
            }
            ImageComponent imageComponent = new ImageComponent(component);
            if (imageComponent.source == Source.NONEXISTING) {
                LOGGER.error("The image from {} does not have a valid file reference.", (Object)component.getPath());
                response.sendError(404);
                return;
            }
            ValueMap componentProperties = component.getValueMap();
            long lastModifiedEpoch = 0L;
            Calendar lastModifiedDate = (Calendar)componentProperties.get("jcr:lastModified", Calendar.class);
            if (lastModifiedDate == null) {
                lastModifiedDate = (Calendar)componentProperties.get("cq:lastModified", Calendar.class);
            }
            if (lastModifiedDate != null) {
                lastModifiedEpoch = lastModifiedDate.getTimeInMillis();
            }
            Asset asset = null;
            if (imageComponent.source == Source.ASSET) {
                asset = (Asset)imageComponent.imageResource.adaptTo(Asset.class);
                if (asset == null) {
                    LOGGER.error("Unable to adapt resource {} used by image {} to an asset.", (Object)imageComponent.imageResource.getPath(), (Object)component.getPath());
                    response.sendError(404);
                    return;
                }
                long assetLastModifiedEpoch = asset.getLastModified();
                if (assetLastModifiedEpoch > lastModifiedEpoch) {
                    lastModifiedEpoch = assetLastModifiedEpoch;
                }
            }
            if ((requestLastModifiedSuffix = this.getRequestLastModifiedSuffix(suffix)) >= 0L && requestLastModifiedSuffix != lastModifiedEpoch) {
                String redirectLocation = this.getRedirectLocation(request, lastModifiedEpoch);
                if (StringUtils.isNotEmpty((CharSequence)redirectLocation)) {
                    response.setStatus(302);
                    response.setHeader("Location", redirectLocation);
                    return;
                }
                LOGGER.error("Unable to determine correct redirect location.");
                response.setStatus(404);
                return;
            }
            if (!this.handleIfModifiedSinceHeader(request, response, lastModifiedEpoch)) {
                Map<String, Integer> transformationMap = this.getTransformationMap(selectorList, component);
                Integer jpegQualityInPercentage = transformationMap.get(SELECTOR_QUALITY_KEY);
                double quality = (double)jpegQualityInPercentage.intValue() / 100.0;
                int resizeWidth = transformationMap.get(SELECTOR_WIDTH_KEY);
                String imageType = this.getImageType(requestPathInfo.getExtension());
                if (imageComponent.source == Source.FILE) {
                    this.transformAndStreamFile(response, componentProperties, resizeWidth, quality, imageComponent.imageResource, imageType, imageName);
                } else if (imageComponent.source == Source.ASSET) {
                    this.transformAndStreamAsset(response, componentProperties, resizeWidth, quality, asset, imageType, imageName);
                }
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Invalid image request", (Object)e.getMessage());
            response.sendError(404);
        }
    }

    @Nullable
    private String getRedirectLocation(SlingHttpServletRequest request, long lastModifiedEpoch) {
        RequestPathInfo requestPathInfo = request.getRequestPathInfo();
        if (request.getResource().isResourceType(IMAGE_RESOURCE_TYPE)) {
            return Joiner.on((char)'.').join((Object)Text.escapePath((String)(request.getContextPath() + requestPathInfo.getResourcePath())), (Object)requestPathInfo.getSelectorString(), new Object[]{requestPathInfo.getExtension() + "/" + lastModifiedEpoch, requestPathInfo.getExtension()});
        }
        long lastModifiedSuffix = this.getRequestLastModifiedSuffix(request.getPathInfo());
        String resourcePath = lastModifiedSuffix > 0L ? ResourceUtil.getParent((String)request.getPathInfo()) : request.getPathInfo();
        String extension = FilenameUtils.getExtension((String)resourcePath);
        if (StringUtils.isNotEmpty((CharSequence)resourcePath)) {
            if (StringUtils.isNotEmpty((CharSequence)extension)) {
                resourcePath = resourcePath.substring(0, resourcePath.length() - extension.length() - 1);
            }
            return request.getContextPath() + Text.escapePath((String)resourcePath) + "/" + lastModifiedEpoch + "." + requestPathInfo.getExtension();
        }
        return null;
    }

    private void transformAndStreamAsset(SlingHttpServletResponse response, ValueMap componentProperties, int resizeWidth, double quality, Asset asset, String imageType, String imageName) throws IOException {
        String extension = this.mimeTypeService.getExtension(imageType);
        if ("gif".equalsIgnoreCase(extension) || "svg".equalsIgnoreCase(extension)) {
            LOGGER.debug("GIF or SVG asset detected; will render the original rendition.");
            this.stream(response, asset.getOriginal().getStream(), imageType, imageName);
            return;
        }
        int rotationAngle = this.getRotation(componentProperties);
        Rectangle rectangle = this.getCropRect(componentProperties);
        boolean flipHorizontally = (Boolean)componentProperties.get("imageFlipHorizontal", (Object)Boolean.FALSE);
        boolean flipVertically = (Boolean)componentProperties.get("imageFlipVertical", (Object)Boolean.FALSE);
        if (rotationAngle != 0 || rectangle != null || resizeWidth > 0 || flipHorizontally || flipVertically) {
            int originalWidth = this.getDimension(asset.getMetadataValue("tiff:ImageWidth"));
            int originalHeight = this.getDimension(asset.getMetadataValue("tiff:ImageLength"));
            Layer layer = null;
            boolean appliedTransformation = false;
            if (rectangle != null) {
                EnhancedRendition wcmRendition = this.getWCMRendition(asset);
                Dimension renditionDimension = wcmRendition.getDimension();
                double renditionWidth = renditionDimension != null ? renditionDimension.getWidth() : (double)originalWidth;
                double scaling = (double)originalWidth > renditionWidth ? (double)originalWidth / renditionWidth : (originalWidth > 0 ? renditionWidth / (double)originalWidth : 1.0);
                layer = this.getLayer(this.getOriginal(asset));
                if (Math.abs(scaling - 1.0) != 0.0) {
                    Rectangle scaledRectangle = new Rectangle((int)((double)rectangle.x * scaling), (int)((double)rectangle.y * scaling), (int)(rectangle.getWidth() * scaling), (int)(rectangle.getHeight() * scaling));
                    layer.crop((Rectangle2D)scaledRectangle);
                } else {
                    layer.crop((Rectangle2D)rectangle);
                }
                appliedTransformation = true;
            }
            if (rotationAngle != 0) {
                if (layer == null) {
                    layer = this.getLayer(this.getBestRendition(asset, resizeWidth));
                }
                layer.rotate((double)rotationAngle);
                LOGGER.debug("Applied rotation transformation ({} degrees).", (Object)rotationAngle);
                appliedTransformation = true;
            }
            if (flipHorizontally) {
                if (layer == null) {
                    layer = this.getLayer(this.getBestRendition(asset, resizeWidth));
                }
                layer.flipHorizontally();
                LOGGER.debug("Flipped image horizontally.");
                appliedTransformation = true;
            }
            if (flipVertically) {
                if (layer == null) {
                    layer = this.getLayer(this.getBestRendition(asset, resizeWidth));
                }
                layer.flipVertically();
                LOGGER.debug("Flipped image vertically.");
                appliedTransformation = true;
            }
            if (!appliedTransformation) {
                EnhancedRendition rendition = this.getBestRendition(asset, resizeWidth);
                Dimension dimension = rendition.getDimension();
                if (dimension != null) {
                    originalHeight = Math.round((float)originalHeight * ((float)dimension.width / (float)originalWidth));
                    originalWidth = dimension.width;
                }
                if (originalWidth > resizeWidth) {
                    int resizeHeight = this.calculateResizeHeight(originalWidth, originalHeight, resizeWidth);
                    if (resizeHeight > 0 && resizeHeight != originalHeight) {
                        layer = this.getLayer(rendition);
                        layer.resize(resizeWidth, resizeHeight);
                        response.setContentType(imageType);
                        LOGGER.debug("Resizing asset {}/{} to requested width of {}px; rendering.", new Object[]{asset.getPath(), rendition.getName(), resizeWidth});
                        layer.write(imageType, quality, (OutputStream)response.getOutputStream());
                    } else {
                        LOGGER.debug("Found rendition {}/{} has a width of {}px and does not require a resize for requested width of {}px", new Object[]{asset.getPath(), rendition.getName(), dimension != null ? Double.valueOf(dimension.getWidth()) : null, resizeWidth});
                        this.stream(response, rendition.getStream(), imageType, imageName);
                    }
                } else {
                    LOGGER.debug("Found rendition {}/{} has a width of {}px and does not require a resize for requested width of {}px", new Object[]{asset.getPath(), rendition.getName(), dimension != null ? Double.valueOf(dimension.getWidth()) : null, resizeWidth});
                    this.stream(response, rendition.getStream(), imageType, imageName);
                }
            } else {
                this.resizeAndStreamLayer(response, layer, imageType, resizeWidth, quality);
            }
        } else {
            LOGGER.debug("No need to perform any processing on asset {}; rendering.", (Object)asset.getPath());
            this.stream(response, this.getOriginal(asset).getStream(), imageType, imageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformAndStreamFile(SlingHttpServletResponse response, ValueMap componentProperties, int resizeWidth, double quality, Resource imageFile, String imageType, String imageName) throws IOException {
        InputStream is;
        block10: {
            block8: {
                block9: {
                    is = null;
                    try {
                        is = (InputStream)imageFile.adaptTo(InputStream.class);
                        if (!"gif".equalsIgnoreCase(this.mimeTypeService.getExtension(imageType)) && !"svg".equalsIgnoreCase(this.mimeTypeService.getExtension(imageType))) break block8;
                        LOGGER.debug("GIF or SVG file detected; will render the original file.");
                        if (is == null) break block9;
                        this.stream(response, is, imageType, imageName);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)is);
                return;
            }
            int rotationAngle = this.getRotation(componentProperties);
            Rectangle rectangle = this.getCropRect(componentProperties);
            boolean flipHorizontally = (Boolean)componentProperties.get("imageFlipHorizontal", (Object)Boolean.FALSE);
            boolean flipVertically = (Boolean)componentProperties.get("imageFlipVertical", (Object)Boolean.FALSE);
            if (is == null) break block10;
            if (rotationAngle != 0 || rectangle != null || resizeWidth > 0 || flipHorizontally || flipVertically) {
                Layer layer = new Layer(is);
                if (rectangle != null) {
                    layer.crop((Rectangle2D)rectangle);
                    LOGGER.debug("Applied cropping transformation.");
                }
                if (rotationAngle != 0) {
                    layer.rotate((double)rotationAngle);
                    LOGGER.debug("Applied rotation transformation ({} degrees).", (Object)rotationAngle);
                }
                if (flipHorizontally) {
                    layer.flipHorizontally();
                }
                if (flipVertically) {
                    layer.flipVertically();
                }
                this.resizeAndStreamLayer(response, layer, imageType, resizeWidth, quality);
                break block10;
            }
            LOGGER.debug("No need to perform any processing on file {}; rendering.", (Object)imageFile.getPath());
            this.stream(response, is, imageType, imageName);
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    private void resizeAndStreamLayer(SlingHttpServletResponse response, Layer layer, String imageType, int resizeWidth, double quality) throws IOException {
        int height;
        int width = layer.getWidth();
        int resizeHeight = this.calculateResizeHeight(width, height = layer.getHeight(), resizeWidth);
        if (resizeHeight > 0) {
            layer.resize(resizeWidth, resizeHeight);
            response.setContentType(imageType);
            LOGGER.debug("Resizing processed (cropped and/or rotated) layer from its current width of {}px to {}px.", (Object)width, (Object)resizeWidth);
            layer.write(imageType, quality, (OutputStream)response.getOutputStream());
        } else {
            response.setContentType(imageType);
            LOGGER.debug("No need to resize processed (cropped and/or rotated) layer since it would lead to upscaling; rendering.");
            layer.write(imageType, quality, (OutputStream)response.getOutputStream());
        }
    }

    @NotNull
    private Layer getLayer(@NotNull EnhancedRendition rendition) throws IOException {
        AssetHandler assetHandler = this.assetStore.getAssetHandler(rendition.getMimeType());
        return new Layer(assetHandler.getImage((Rendition)rendition));
    }

    @NotNull
    private EnhancedRendition getWCMRendition(@NotNull Asset asset) {
        return new EnhancedRendition(asset.getRendition((RenditionPicker)new WCMRenditionPicker()));
    }

    @NotNull
    private EnhancedRendition getBestRendition(@NotNull Asset asset, int width) throws IOException {
        TreeSet renditions = new TreeSet((o1, o2) -> Long.valueOf(o1.getSize() - o2.getSize()).intValue());
        renditions.addAll(asset.getRenditions());
        EnhancedRendition bestRendition = null;
        for (Rendition rendition : renditions) {
            EnhancedRendition enhancedRendition = new EnhancedRendition(rendition);
            Dimension dimension = enhancedRendition.getDimension();
            if (dimension == null || !(dimension.getWidth() >= (double)width)) continue;
            bestRendition = enhancedRendition;
            break;
        }
        if (bestRendition == null) {
            bestRendition = new EnhancedRendition(asset.getOriginal());
        }
        return this.filter(bestRendition);
    }

    @NotNull
    private EnhancedRendition getOriginal(@NotNull Asset asset) throws IOException {
        EnhancedRendition original = new EnhancedRendition(asset.getOriginal());
        return this.filter(original);
    }

    @NotNull
    private EnhancedRendition filter(@NotNull EnhancedRendition rendition) throws IOException {
        Dimension dimension = rendition.getDimension();
        if (dimension != null && dimension.getWidth() <= (double)this.maxInputWidth) {
            return rendition;
        }
        throw new IOException(String.format("Cannot process rendition %s due to size %s", rendition.getName(), rendition.getDimension()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stream(@NotNull SlingHttpServletResponse response, @NotNull InputStream inputStream, @NotNull String contentType, String imageName) throws IOException {
        response.setContentType(contentType);
        response.setHeader("Content-Disposition", "inline; filename=" + URLEncoder.encode(imageName, "UTF-8"));
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private Rectangle getCropRect(@NotNull ValueMap properties) {
        String csv = (String)properties.get("imageCrop", String.class);
        if (StringUtils.isNotEmpty((CharSequence)csv)) {
            try {
                int ratio = csv.indexOf(47);
                if (ratio >= 0) {
                    csv = csv.substring(0, ratio);
                }
                String[] coords = csv.split(",");
                int x1 = Integer.parseInt(coords[0]);
                int y1 = Integer.parseInt(coords[1]);
                int x2 = Integer.parseInt(coords[2]);
                int y2 = Integer.parseInt(coords[3]);
                return new Rectangle(x1, y1, x2 - x1, y2 - y1);
            }
            catch (RuntimeException e) {
                LOGGER.warn(String.format("Invalid cropping rectangle %s.", csv), (Throwable)e);
            }
        }
        return null;
    }

    private int getRotation(@NotNull ValueMap properties) {
        String rotationString = (String)properties.get("imageRotate", String.class);
        if (rotationString != null) {
            try {
                return Integer.parseInt(rotationString);
            }
            catch (NumberFormatException e) {
                LOGGER.warn(String.format("Invalid rotation value %s.", rotationString), (Throwable)e);
            }
        }
        return 0;
    }

    private int getDimension(String stringValue) {
        try {
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private int calculateResizeHeight(int assetWidth, int assetHeight, int resizeWidth) {
        if (assetWidth > 0 && assetHeight > 0 && resizeWidth < assetWidth) {
            double scaleFactor = (double)resizeWidth / (double)assetWidth;
            return (int)(scaleFactor * (double)assetHeight);
        }
        if (assetWidth > 0 && assetHeight > 0 && resizeWidth == assetWidth) {
            return assetHeight;
        }
        return 0;
    }

    private boolean handleIfModifiedSinceHeader(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, long lastModified) {
        if (lastModified > 0L) {
            long ifModifiedSince = request.getDateHeader("If-Modified-Since") / 1000L;
            if (lastModified / 1000L <= ifModifiedSince) {
                response.setStatus(304);
                LOGGER.debug("If-Modified-Since header was present in the request. The resource was not changed, therefore replying with a 304 status code.");
                return true;
            }
            response.setDateHeader("Last-Modified", lastModified);
        }
        return false;
    }

    private String getImageType(String ext) {
        if (ext == null) {
            return DEFAULT_MIME;
        }
        if ("tiff".equalsIgnoreCase(ext) || "tif".equalsIgnoreCase(ext)) {
            return DEFAULT_MIME;
        }
        return this.mimeTypeService.getMimeType(ext);
    }

    private ContentPolicy getContentPolicy(@NotNull Resource imageResource) {
        ResourceResolver resourceResolver = imageResource.getResourceResolver();
        ContentPolicyManager policyManager = (ContentPolicyManager)resourceResolver.adaptTo(ContentPolicyManager.class);
        if (policyManager != null) {
            String delegatingResourceType;
            Component component;
            ComponentManager componentManager = (ComponentManager)resourceResolver.adaptTo(ComponentManager.class);
            if (componentManager != null && (component = componentManager.getComponentOfResource(imageResource)) != null && component.getProperties() != null && StringUtils.isNotEmpty((CharSequence)(delegatingResourceType = (String)component.getProperties().get("imageDelegate", String.class)))) {
                imageResource = new ImageResourceWrapper((Resource)imageResource, delegatingResourceType);
            }
            return policyManager.getPolicy(imageResource);
        }
        LOGGER.warn("Could not get policy manager from resource resolver!");
        return null;
    }

    private List<String> selectorToList(String selector) throws IllegalArgumentException {
        if (StringUtils.isEmpty((CharSequence)selector)) {
            throw new IllegalArgumentException("Expected 1, 2 or 3 selectors instead got empty selector");
        }
        ArrayList selectorList = Lists.newArrayList((Iterable)Splitter.on((char)'.').omitEmptyStrings().trimResults().split((CharSequence)selector));
        if (selectorList.size() > 3) {
            throw new IllegalArgumentException("Expected 1, 2 or 3 selectors, instead got: " + selectorList.size());
        }
        return selectorList;
    }

    private Map<String, Integer> getTransformationMap(List<String> selectorList, Resource component) throws IllegalArgumentException {
        HashMap<String, Integer> selectorParameterMap = new HashMap<String, Integer>();
        int width = this.defaultResizeWidth;
        if (selectorList.size() > 1) {
            String widthString = selectorList.size() > 2 ? selectorList.get(2) : selectorList.get(1);
            try {
                width = Integer.parseInt(widthString);
                if (width <= 0) {
                    throw new IllegalArgumentException();
                }
                List<Integer> allowedRenditionWidths = this.getAllowedRenditionWidths(component);
                if (!allowedRenditionWidths.contains(width)) {
                    throw new IllegalArgumentException("The requested width is not allowed in the content policy or no default");
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Third selector must contain a valid width information (selector > 0)");
            }
        }
        selectorParameterMap.put(SELECTOR_WIDTH_KEY, width);
        int quality = 82;
        if (selectorList.size() > 2) {
            String qualityString = selectorList.get(1);
            try {
                int qualityPercentage = Integer.parseInt(qualityString);
                if (qualityPercentage <= 0 || qualityPercentage > 100) {
                    throw new IllegalArgumentException();
                }
                Integer allowedJpegQuality = this.getAllowedJpegQuality(component);
                if (qualityPercentage != allowedJpegQuality) {
                    throw new IllegalArgumentException("The requested quality is not allowed in the content policy or no default");
                }
                quality = qualityPercentage;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Second selector must be a valid quality in percentage (100 <= selector > 0)");
            }
        }
        selectorParameterMap.put(SELECTOR_QUALITY_KEY, quality);
        return selectorParameterMap;
    }

    private List<Integer> getAllowedRenditionWidths(@NotNull Resource imageResource) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        ContentPolicy contentPolicy = this.getContentPolicy(imageResource);
        if (contentPolicy != null) {
            String[] allowedRenditionWidths;
            for (String width : allowedRenditionWidths = (String[])contentPolicy.getProperties().get("allowedRenditionWidths", (Object)new String[0])) {
                try {
                    list.add(Integer.parseInt(width));
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("One of the configured widths ({}) from the {} content policy is not a valid Integer.", (Object)width, (Object)contentPolicy.getPath());
                    return list;
                }
            }
        }
        if (list.isEmpty()) {
            list.add(this.defaultResizeWidth);
        }
        return list;
    }

    private Integer getAllowedJpegQuality(@NotNull Resource imageResource) {
        Integer allowedJpegQuality = 82;
        ContentPolicy contentPolicy = this.getContentPolicy(imageResource);
        if (contentPolicy != null) {
            allowedJpegQuality = (Integer)contentPolicy.getProperties().get("jpegQuality", (Object)82);
        }
        return allowedJpegQuality;
    }

    private long getRequestLastModifiedSuffix(@Nullable String suffix) {
        long requestLastModified = 0L;
        if (StringUtils.isNotEmpty((CharSequence)suffix) && suffix.contains(".")) {
            Pattern p = Pattern.compile("\\(|\\)|\\/\\d{13}");
            Matcher m = p.matcher(suffix);
            if (!m.find()) {
                return requestLastModified;
            }
            try {
                requestLastModified = Long.parseLong(ResourceUtil.getName((String)m.group()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return requestLastModified;
    }

    private static class ImageComponent {
        Source source = Source.NONEXISTING;
        Resource imageResource;

        ImageComponent(@NotNull Resource component) {
            String fileReference = (String)component.getValueMap().get("fileReference", String.class);
            if (StringUtils.isNotEmpty((CharSequence)fileReference)) {
                this.imageResource = component.getResourceResolver().getResource(fileReference);
                this.source = Source.ASSET;
            } else {
                Resource jcrContent;
                Resource childFileNode = component.getChild("file");
                if (childFileNode != null && "nt:file".equals(childFileNode.getResourceType()) && (jcrContent = childFileNode.getChild("jcr:content")) != null && jcrContent.getValueMap().containsKey((Object)"jcr:data")) {
                    this.imageResource = childFileNode;
                    this.source = Source.FILE;
                }
            }
        }
    }

    private static enum Source {
        ASSET,
        FILE,
        NONEXISTING;

    }
}

