/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets;

import com.adobe.cq.wcm.core.components.internal.servlets.TextValueDataResourceSource;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.day.cq.wcm.api.policies.ContentPolicy;
import com.day.cq.wcm.api.policies.ContentPolicyManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=core/wcm/components/commons/datasources/allowedheadingelements/v1", "sling.servlet.resourceTypes=core/wcm/components/title/v1/datasource/allowedtypes", "sling.servlet.methods=GET", "sling.servlet.extensions=html"})
public class AllowedHeadingElementsDataSourceServlet
extends SlingSafeMethodsServlet {
    public static final String RESOURCE_TYPE_V1 = "core/wcm/components/commons/datasources/allowedheadingelements/v1";
    public static final String RESOURCE_TYPE_TITLE_V1 = "core/wcm/components/title/v1/datasource/allowedtypes";
    public static final String PN_ALLOWED_HEADING_ELEMENTS = "allowedHeadingElements";
    public static final String PN_DEFAULT_HEADING_ELEMENT = "headingElement";
    public static final String PN_ALLOWED_TYPES = "allowedTypes";
    public static final String PN_DEFAULT_TYPE = "type";

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        SimpleDataSource allowedHeadingElementsDataSource = new SimpleDataSource(this.getAllowedHeadingElements(request).iterator());
        request.setAttribute(DataSource.class.getName(), (Object)allowedHeadingElementsDataSource);
    }

    private List<Resource> getAllowedHeadingElements(@NotNull SlingHttpServletRequest request) {
        ValueMap props;
        ContentPolicy policy;
        ArrayList<Resource> allowedHeadingElements = new ArrayList<Resource>();
        ResourceResolver resolver = request.getResourceResolver();
        Resource contentResource = resolver.getResource((String)request.getAttribute("granite.ui.form.contentpath"));
        ContentPolicyManager policyManager = (ContentPolicyManager)resolver.adaptTo(ContentPolicyManager.class);
        if (contentResource != null && policyManager != null && (policy = policyManager.getPolicy(contentResource)) != null && (props = policy.getProperties()) != null) {
            String[] headingElements = (String[])props.get(PN_ALLOWED_HEADING_ELEMENTS, String[].class);
            String[] allowedTypes = (String[])props.get(PN_ALLOWED_TYPES, String[].class);
            String defaultHeadingElement = (String)props.get(PN_DEFAULT_HEADING_ELEMENT, props.get(PN_DEFAULT_TYPE, (Object)""));
            if (headingElements == null || headingElements.length == 0) {
                headingElements = allowedTypes;
            }
            if (headingElements != null && headingElements.length > 0) {
                for (String headingElement : headingElements) {
                    allowedHeadingElements.add((Resource)new HeadingElementResource(headingElement, StringUtils.equals((CharSequence)headingElement, (CharSequence)defaultHeadingElement), resolver));
                }
            }
        }
        return allowedHeadingElements;
    }

    private static enum Heading {
        H1("h1"),
        H2("h2"),
        H3("h3"),
        H4("h4"),
        H5("h5"),
        H6("h6");

        private String element;

        private Heading(String element) {
            this.element = element;
        }

        private static Heading getHeading(String value) {
            for (Heading heading : Heading.values()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)heading.element, (CharSequence)value)) continue;
                return heading;
            }
            return null;
        }

        public String getElement() {
            return this.element;
        }
    }

    private static class HeadingElementResource
    extends TextValueDataResourceSource {
        private final String elementName;
        private final boolean selected;

        HeadingElementResource(String headingElement, boolean defaultElement, ResourceResolver resourceResolver) {
            super(resourceResolver, "", "sling:nonexisting");
            this.elementName = headingElement;
            this.selected = defaultElement;
        }

        @Override
        public String getText() {
            Heading heading = Heading.getHeading(this.elementName);
            if (heading != null) {
                return heading.getElement();
            }
            return null;
        }

        @Override
        public String getValue() {
            return this.elementName;
        }

        @Override
        public boolean getSelected() {
            return this.selected;
        }
    }
}

