/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets;

import com.adobe.cq.wcm.core.components.internal.servlets.ContainerServlet;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.s7dam.utils.PublishUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.ModificationType;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SlingPostProcessor.class})
public final class DMAssetPostProcessor
implements SlingPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerServlet.class);
    private static final String IMAGE_SERVER_PATH = "/is/image/";
    @Reference
    private PublishUtils publishUtils;

    public void process(SlingHttpServletRequest request, List<Modification> list) throws Exception {
        Modification lastFileReferenceModification = DMAssetPostProcessor.getLastPropertyModification(request, list, "fileReference");
        if (lastFileReferenceModification != null) {
            switch (lastFileReferenceModification.getType()) {
                case CREATE: 
                case MODIFY: {
                    ValueMap valueMap = request.getResource().getValueMap();
                    String fileReference = (String)valueMap.get("fileReference", String.class);
                    if (fileReference != null) {
                        Resource assetResource = request.getResourceResolver().getResource(fileReference);
                        if (assetResource != null) {
                            Asset asset = (Asset)assetResource.adaptTo(Asset.class);
                            if (asset != null) {
                                if (DMAssetPostProcessor.isDmAsset(asset)) {
                                    String[] productionAssetUrls = this.publishUtils.externalizeImageDeliveryAsset(assetResource);
                                    String imageServerUrl = productionAssetUrls[0] + IMAGE_SERVER_PATH;
                                    DMAssetPostProcessor.checkSetProperty(request.getResource(), "imageServerUrl", imageServerUrl, list);
                                } else {
                                    DMAssetPostProcessor.checkSetProperty(request.getResource(), "imageServerUrl", null, list);
                                }
                                Modification lastFileModification = DMAssetPostProcessor.getLastPropertyModification(request, list, "file");
                                if (lastFileModification == null || lastFileModification.getType() != ModificationType.DELETE) break;
                                DMAssetPostProcessor.checkSetProperty(request.getResource(), "smartCropRendition", null, list);
                                break;
                            }
                            LOGGER.error("Unable to adapt resource '{}' used by image '{}' to an asset.", (Object)fileReference, (Object)request.getResource().getPath());
                            break;
                        }
                        LOGGER.error("Unable to find resource '{}' used by image '{}'.", (Object)fileReference, (Object)request.getResource().getPath());
                        break;
                    }
                    LOGGER.warn("File reference was null despite '{}' modification type.", (Object)lastFileReferenceModification.getType());
                    break;
                }
                case DELETE: {
                    DMAssetPostProcessor.checkSetProperty(request.getResource(), "imageServerUrl", null, list);
                    DMAssetPostProcessor.checkSetProperty(request.getResource(), "smartCropRendition", null, list);
                    break;
                }
            }
        }
    }

    private static void checkSetProperty(Resource resource, String name, String value, List<Modification> list) {
        ModifiableValueMap map = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        if (map != null) {
            ValueMap valueMap = resource.getValueMap();
            if (value != null) {
                String oldValue = (String)valueMap.get(name, String.class);
                if (!value.equals(oldValue)) {
                    list.add(new Modification(oldValue != null ? ModificationType.MODIFY : ModificationType.CREATE, DMAssetPostProcessor.getModificationSource(resource.getPath(), name), null));
                    map.put((Object)name, (Object)value);
                }
            } else if (valueMap.containsKey((Object)name)) {
                list.add(new Modification(ModificationType.DELETE, DMAssetPostProcessor.getModificationSource(resource.getPath(), name), null));
                map.remove((Object)name);
            }
        } else {
            LOGGER.warn("Cannot adapt resource '{}' to ModifiableValueMap.", (Object)resource);
        }
    }

    private static boolean isDmAsset(Asset asset) {
        String dmAssetName = asset.getMetadataValue("dam:scene7File");
        return !StringUtils.isEmpty((CharSequence)dmAssetName);
    }

    private static Modification getLastPropertyModification(SlingHttpServletRequest request, List<Modification> list, String propertyName) {
        String expectedModificationSource = request.getResource().getPath() + "/" + propertyName;
        Modification lastPropertyModification = null;
        for (Modification modification : list) {
            if (!expectedModificationSource.equals(modification.getSource())) continue;
            lastPropertyModification = modification;
        }
        return lastPropertyModification;
    }

    private static String getModificationSource(String path, String name) {
        return path + "/" + name;
    }
}

