/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import java.awt.Dimension;
import java.io.InputStream;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancedRendition
extends ResourceWrapper
implements Rendition {
    private static final Logger LOG = LoggerFactory.getLogger(EnhancedRendition.class);
    private Rendition rendition;
    private Dimension dimension;
    private boolean dimensionProcessed = false;

    public EnhancedRendition(@NotNull Rendition rendition) {
        super((Resource)rendition);
        this.rendition = rendition;
    }

    @Nullable
    public Dimension getDimension() {
        if (!this.dimensionProcessed) {
            if ("original".equals(this.getName())) {
                try {
                    Asset asset = this.getAsset();
                    int width = Integer.parseInt(asset.getMetadataValue("tiff:ImageWidth"));
                    int height = Integer.parseInt(asset.getMetadataValue("tiff:ImageLength"));
                    this.dimension = new Dimension(width, height);
                }
                catch (NumberFormatException nfex) {
                    LOG.error("Cannot parse original asset dimensions", (Throwable)nfex);
                }
            } else if (this.getProperties().containsKey((Object)"tiff:ImageWidth") && this.getProperties().containsKey((Object)"tiff:ImageLength")) {
                try {
                    int width = Integer.parseInt((String)this.getProperties().get("tiff:ImageWidth", String.class));
                    int height = Integer.parseInt((String)this.getProperties().get("tiff:ImageLength", String.class));
                    this.dimension = new Dimension(width, height);
                }
                catch (NumberFormatException nfex) {
                    LOG.error("Cannot parse rendition dimensions from metadata", (Throwable)nfex);
                }
            } else if (StringUtils.startsWith((CharSequence)this.rendition.getMimeType(), (CharSequence)"image/") && (double)this.rendition.getSize() < Math.pow(3840.0, 2.0)) {
                try (InputStream stream = this.getStream();){
                    this.dimension = Imaging.getImageSize((InputStream)stream, (String)this.getName());
                }
                catch (Exception e) {
                    LOG.error("Cannot get rendition {} dimension from stream", (Object)this.getName(), (Object)e);
                }
            }
            this.dimensionProcessed = true;
        }
        return this.dimension;
    }

    public String getMimeType() {
        return this.rendition.getMimeType();
    }

    public ValueMap getProperties() {
        return this.rendition.getProperties();
    }

    public long getSize() {
        return this.rendition.getSize();
    }

    public InputStream getStream() {
        return this.rendition.getStream();
    }

    public Asset getAsset() {
        return this.rendition.getAsset();
    }
}

