/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets;

import com.adobe.cq.wcm.core.components.internal.Utils;
import com.adobe.cq.wcm.core.components.services.form.FormHandler;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.foundation.forms.FormsHandlingRequest;
import com.day.cq.wcm.foundation.forms.FormsHandlingServletHelper;
import com.day.cq.wcm.foundation.forms.ValidationInfo;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=POST", "sling.servlet.resourceTypes=core/wcm/components/form/actions/rpc", "sling.servlet.selectors=post"})
public class FormActionRpcServlet
extends SlingAllMethodsServlet {
    static final String SELECTOR = "post";
    static final String RESOURCE_TYPE = "core/wcm/components/form/actions/rpc";
    private static final String ATTR_RESOURCE = FormsHandlingServletHelper.class.getName() + "/resource";
    private static final String PN_FORM_ENDPOINT_URL = "externalServiceEndPointUrl";
    private static final Logger LOG = LoggerFactory.getLogger(FormActionRpcServlet.class);
    public static final String HTML_SUFFIX = ".html";
    @Reference
    private FormHandler formHandler;

    protected void doPost(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws ServletException {
        boolean processFormApiSuccess = false;
        Resource formContainerResource = request.getResource();
        ValueMap valueMap = (ValueMap)formContainerResource.adaptTo(ValueMap.class);
        if (valueMap != null) {
            String endPointUrl = (String)valueMap.get(PN_FORM_ENDPOINT_URL, String.class);
            if (StringUtils.isNotEmpty((String)endPointUrl)) {
                JSONObject formData = new JSONObject();
                try {
                    formData = Utils.getJsonOfRequestParameters(request);
                }
                catch (JSONException e) {
                    LOG.error("Unable to get JSON form request parameter", (Throwable)e);
                }
                processFormApiSuccess = this.formHandler.forwardFormData(formData, endPointUrl);
            }
            this.sendRedirect(valueMap, request, response, processFormApiSuccess);
        }
    }

    private void sendRedirect(ValueMap valueMap, SlingHttpServletRequest request, SlingHttpServletResponse response, boolean processFormApiSuccess) throws ServletException {
        block5: {
            String redirect = this.getMappedRedirect((String)valueMap.get("redirect", String.class), request.getResourceResolver());
            String errorMessage = (String)valueMap.get("errorMessage", String.class);
            FormsHandlingRequest formRequest = new FormsHandlingRequest(request);
            try {
                if (StringUtils.isNotEmpty((String)redirect) && processFormApiSuccess) {
                    response.sendRedirect(redirect);
                    break block5;
                }
                if (!processFormApiSuccess && StringUtils.isNotEmpty((String)errorMessage)) {
                    ValidationInfo validationInfo = ValidationInfo.createValidationInfo((SlingHttpServletRequest)request);
                    validationInfo.addErrorMessage(null, errorMessage);
                }
                Resource formResource = (Resource)request.getAttribute(ATTR_RESOURCE);
                request.removeAttribute(ATTR_RESOURCE);
                request.removeAttribute(ComponentContext.BYPASS_COMPONENT_HANDLING_ON_INCLUDE_ATTRIBUTE);
                RequestDispatcher requestDispatcher = request.getRequestDispatcher(formResource);
                if (requestDispatcher != null) {
                    requestDispatcher.forward((ServletRequest)formRequest, (ServletResponse)response);
                    break block5;
                }
                throw new IOException("can't get request dispatcher to forward the response");
            }
            catch (IOException var13) {
                LOG.error("Error redirecting to {}", (Object)redirect);
            }
        }
    }

    private String getMappedRedirect(String redirect, ResourceResolver resourceResolver) {
        String mappedRedirect = null;
        if (StringUtils.isNotEmpty((String)redirect)) {
            if (StringUtils.endsWith((String)redirect, (String)HTML_SUFFIX)) {
                Resource resource = resourceResolver.resolve(redirect);
                if (!(resource instanceof NonExistingResource)) {
                    mappedRedirect = redirect;
                }
            } else {
                Resource resource = resourceResolver.getResource(redirect);
                if (resource != null) {
                    redirect = redirect + HTML_SUFFIX;
                    mappedRedirect = resourceResolver.map(redirect);
                }
            }
        }
        return mappedRedirect;
    }
}

