/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets;

import com.adobe.cq.wcm.core.components.internal.models.v1.PageListItemImpl;
import com.adobe.cq.wcm.core.components.models.ListItem;
import com.adobe.cq.wcm.core.components.util.ComponentUtils;
import com.day.cq.search.PredicateConverter;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import com.day.cq.wcm.api.LanguageManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.api.policies.ContentPolicy;
import com.day.cq.wcm.api.policies.ContentPolicyManager;
import com.day.cq.wcm.msm.api.LiveRelationship;
import com.day.cq.wcm.msm.api.LiveRelationshipManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.selectors=searchresults", "sling.servlet.resourceTypes=cq/Page", "sling.servlet.extensions=json", "sling.servlet.methods=GET"})
public class SearchResultServlet
extends SlingSafeMethodsServlet {
    protected static final String DEFAULT_SELECTOR = "searchresults";
    protected static final String PARAM_FULLTEXT = "fulltext";
    private static final String PARAM_RESULTS_OFFSET = "resultsOffset";
    private static final String PREDICATE_FULLTEXT = "fulltext";
    private static final String PREDICATE_TYPE = "type";
    private static final String PREDICATE_PATH = "path";
    private static final String NN_STRUCTURE = "structure";
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchResultServlet.class);
    @Reference
    private transient QueryBuilder queryBuilder;
    @Reference
    private transient LanguageManager languageManager;
    @Reference
    private transient LiveRelationshipManager relationshipManager;

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        Page currentPage = this.getCurrentPage(request);
        if (currentPage != null) {
            Resource searchResource = this.getSearchContentResource(request, currentPage);
            List<ListItem> results = this.getResults(request, searchResource, currentPage);
            this.writeJson(results, response);
        }
    }

    private Page getCurrentPage(SlingHttpServletRequest request) {
        Page currentPage = null;
        Resource currentResource = request.getResource();
        ResourceResolver resourceResolver = currentResource.getResourceResolver();
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        if (pageManager != null) {
            currentPage = pageManager.getContainingPage(currentResource.getPath());
        }
        return currentPage;
    }

    private void writeJson(List<ListItem> results, SlingHttpServletResponse response) {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        ObjectMapper mapper = new ObjectMapper();
        try {
            mapper.writeValue((Writer)response.getWriter(), results);
        }
        catch (IOException e) {
            LOGGER.error("cannot serialize to JSON", (Throwable)e);
        }
    }

    private Resource getSearchContentResource(SlingHttpServletRequest request, Page currentPage) {
        Resource templateResource;
        Template template;
        PageManager pageManager;
        Resource searchContentResource = null;
        RequestPathInfo requestPathInfo = request.getRequestPathInfo();
        Resource resource = request.getResource();
        String relativeContentResource = requestPathInfo.getSuffix();
        if (StringUtils.startsWith((CharSequence)relativeContentResource, (CharSequence)"/")) {
            relativeContentResource = StringUtils.substring((String)relativeContentResource, (int)1);
        }
        if (StringUtils.isNotEmpty((CharSequence)relativeContentResource) && (searchContentResource = resource.getChild(relativeContentResource)) == null && (pageManager = (PageManager)resource.getResourceResolver().adaptTo(PageManager.class)) != null && (template = currentPage.getTemplate()) != null && (templateResource = request.getResourceResolver().getResource(template.getPath())) != null) {
            searchContentResource = templateResource.getChild("structure/" + relativeContentResource);
        }
        return searchContentResource;
    }

    private List<ListItem> getResults(SlingHttpServletRequest request, Resource searchResource, Page currentPage) {
        SearchResult searchResult;
        List hits;
        String searchRootPagePath;
        int searchTermMinimumLength = 3;
        int resultsSize = 10;
        if (searchResource != null) {
            ValueMap valueMap = searchResource.getValueMap();
            ValueMap contentPolicyMap = this.getContentPolicyProperties(searchResource, request.getResource());
            searchTermMinimumLength = (Integer)valueMap.get("searchTermMinimumLength", contentPolicyMap.get("searchTermMinimumLength", (Object)3));
            resultsSize = (Integer)valueMap.get("resultsSize", contentPolicyMap.get("resultsSize", (Object)10));
            String searchRoot = (String)valueMap.get("searchRoot", contentPolicyMap.get("searchRoot", (Object)"/content"));
            searchRootPagePath = this.getSearchRootPagePath(searchRoot, currentPage);
        } else {
            String languageRoot = this.languageManager.getLanguageRoot(currentPage.getContentResource()).getPath();
            searchRootPagePath = this.getSearchRootPagePath(languageRoot, currentPage);
        }
        if (StringUtils.isEmpty((CharSequence)searchRootPagePath)) {
            searchRootPagePath = currentPage.getPath();
        }
        ArrayList<ListItem> results = new ArrayList<ListItem>();
        String fulltext = request.getParameter("fulltext");
        if (fulltext == null || fulltext.length() < searchTermMinimumLength) {
            return results;
        }
        long resultsOffset = 0L;
        if (request.getParameter(PARAM_RESULTS_OFFSET) != null) {
            resultsOffset = Long.parseLong(request.getParameter(PARAM_RESULTS_OFFSET));
        }
        HashMap<String, String> predicatesMap = new HashMap<String, String>();
        predicatesMap.put("fulltext", fulltext);
        predicatesMap.put(PREDICATE_PATH, searchRootPagePath);
        predicatesMap.put(PREDICATE_TYPE, "cq:Page");
        PredicateGroup predicates = PredicateConverter.createPredicates(predicatesMap);
        ResourceResolver resourceResolver = request.getResource().getResourceResolver();
        Query query = this.queryBuilder.createQuery(predicates, (Session)resourceResolver.adaptTo(Session.class));
        if (resultsSize != 0) {
            query.setHitsPerPage((long)resultsSize);
        }
        if (resultsOffset != 0L) {
            query.setStart(resultsOffset);
        }
        if ((hits = (searchResult = query.getResult()).getHits()) != null) {
            for (Hit hit : hits) {
                try {
                    Resource hitRes = hit.getResource();
                    Page page = this.getPage(hitRes);
                    if (page == null) continue;
                    results.add(new PageListItemImpl(request, page, this.getId(searchResource), false, null));
                }
                catch (RepositoryException e) {
                    LOGGER.error("Unable to retrieve search results for query.", (Throwable)e);
                }
            }
        }
        return results;
    }

    private String getId(Resource resource) {
        if (resource == null) {
            return null;
        }
        return ComponentUtils.generateId("search", resource.getPath());
    }

    private String getSearchRootPagePath(String searchRoot, Page currentPage) {
        String searchRootPagePath;
        block4: {
            Page rootPage;
            block6: {
                RangeIterator liveCopiesIterator;
                PageManager pageManager;
                block5: {
                    searchRootPagePath = null;
                    pageManager = currentPage.getPageManager();
                    if (!StringUtils.isNotEmpty((CharSequence)searchRoot) || pageManager == null || (rootPage = pageManager.getPage(searchRoot)) == null) break block4;
                    Page searchRootLanguageRoot = this.languageManager.getLanguageRoot(rootPage.getContentResource());
                    Page currentPageLanguageRoot = this.languageManager.getLanguageRoot(currentPage.getContentResource());
                    liveCopiesIterator = null;
                    try {
                        liveCopiesIterator = this.relationshipManager.getLiveRelationships((Resource)currentPage.adaptTo(Resource.class), null, null);
                    }
                    catch (WCMException wCMException) {
                        // empty catch block
                    }
                    if (searchRootLanguageRoot == null || currentPageLanguageRoot == null || searchRootLanguageRoot.equals(currentPageLanguageRoot)) break block5;
                    Page languageCopySearchRoot = pageManager.getPage(ResourceUtil.normalize((String)(currentPageLanguageRoot.getPath() + "/" + this.getRelativePath(searchRootLanguageRoot, rootPage))));
                    if (languageCopySearchRoot == null) break block6;
                    rootPage = languageCopySearchRoot;
                    break block6;
                }
                if (liveCopiesIterator != null) {
                    while (liveCopiesIterator.hasNext()) {
                        Page liveCopySearchRoot;
                        LiveRelationship relationship = (LiveRelationship)liveCopiesIterator.next();
                        if (!currentPage.getPath().startsWith(relationship.getTargetPath() + "/") || (liveCopySearchRoot = pageManager.getPage(relationship.getTargetPath())) == null) continue;
                        rootPage = liveCopySearchRoot;
                        break;
                    }
                }
            }
            searchRootPagePath = rootPage.getPath();
        }
        return searchRootPagePath;
    }

    private ValueMap getContentPolicyProperties(Resource searchResource, Resource requestedResource) {
        ContentPolicy policy;
        ValueMapDecorator contentPolicyProperties = new ValueMapDecorator(new HashMap());
        ResourceResolver resourceResolver = searchResource.getResourceResolver();
        ContentPolicyManager contentPolicyManager = (ContentPolicyManager)resourceResolver.adaptTo(ContentPolicyManager.class);
        if (contentPolicyManager != null && (policy = contentPolicyManager.getPolicy(searchResource)) != null) {
            contentPolicyProperties = policy.getProperties();
        }
        return contentPolicyProperties;
    }

    @Nullable
    private String getRelativePath(@NotNull Page root, @NotNull Page child) {
        if (child.equals(root)) {
            return ".";
        }
        if ((child.getPath() + "/").startsWith(root.getPath())) {
            return child.getPath().substring(root.getPath().length() + 1);
        }
        return null;
    }

    private Page getPage(Resource resource) {
        ResourceResolver resourceResolver;
        PageManager pageManager;
        if (resource != null && (pageManager = (PageManager)(resourceResolver = resource.getResourceResolver()).adaptTo(PageManager.class)) != null) {
            return pageManager.getContainingPage(resource);
        }
        return null;
    }
}

