/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets.embed;

import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.policies.ContentPolicy;
import com.day.cq.wcm.api.policies.ContentPolicyManager;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=core/wcm/components/embed/v1/datasources/embeddableoptions", "sling.servlet.methods=GET", "sling.servlet.extensions=html"})
public class EmbeddableOptionsDataSourceServlet
extends SlingSafeMethodsServlet {
    public static final String RESOURCE_TYPE_V1 = "core/wcm/components/embed/v1/datasources/embeddableoptions";
    private static final long serialVersionUID = 7672484310019288602L;
    private static final String NN_DIALOG = "cq:dialog";

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) {
        SimpleDataSource embeddableOptionsDataSource = new SimpleDataSource(this.getEmbeddableOptions(request).iterator());
        request.setAttribute(DataSource.class.getName(), (Object)embeddableOptionsDataSource);
    }

    private List<Resource> getEmbeddableOptions(@NotNull SlingHttpServletRequest request) {
        ArrayList<Resource> embeddableOptionsResources = new ArrayList<Resource>();
        ResourceResolver resolver = request.getResourceResolver();
        Resource contentResource = resolver.getResource((String)request.getAttribute("granite.ui.form.contentpath"));
        ContentPolicyManager policyManager = (ContentPolicyManager)resolver.adaptTo(ContentPolicyManager.class);
        if (policyManager != null) {
            String[] allowedEmbeddables;
            ValueMap properties = null;
            ContentPolicy policy = policyManager.getPolicy(contentResource);
            if (policy != null) {
                properties = policy.getProperties();
            } else {
                Designer designer = (Designer)resolver.adaptTo(Designer.class);
                if (designer != null) {
                    properties = designer.getStyle(contentResource);
                }
            }
            if (properties != null && (allowedEmbeddables = (String[])properties.get("allowedEmbeddables", String[].class)) != null && allowedEmbeddables.length > 0) {
                for (String allowedEmbeddable : allowedEmbeddables) {
                    Resource dialogResource = resolver.getResource(allowedEmbeddable + "/" + NN_DIALOG);
                    if (dialogResource == null) continue;
                    embeddableOptionsResources.add(dialogResource);
                }
            }
        }
        return embeddableOptionsResources;
    }
}

