/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets.embed;

import com.adobe.cq.wcm.core.components.internal.servlets.TextValueDataResourceSource;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=core/wcm/components/embed/v1/datasources/embeddables", "sling.servlet.methods=GET", "sling.servlet.extensions=html"})
public class EmbeddablesDataSourceServlet
extends SlingSafeMethodsServlet {
    public static final String RESOURCE_TYPE_V1 = "core/wcm/components/embed/v1/datasources/embeddables";
    private static final long serialVersionUID = 1L;
    private static final String COMPONENT_PROPERTY_ENABLED = "enabled";
    private static final String COMPONENT_PROPERTY_ORDER = "order";

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) {
        SimpleDataSource embeddablesDataSource = new SimpleDataSource(this.getEmbeddableResources(request.getResourceResolver()).iterator());
        request.setAttribute(DataSource.class.getName(), (Object)embeddablesDataSource);
    }

    private List<Resource> getEmbeddableResources(ResourceResolver resourceResolver) {
        ArrayList<Resource> embeddableResources = new ArrayList<Resource>();
        for (EmbeddableDescription description : this.findEmbeddables(resourceResolver)) {
            embeddableResources.add((Resource)new EmbeddableDataResourceSource(description, resourceResolver));
        }
        return embeddableResources;
    }

    private Collection<EmbeddableDescription> findEmbeddables(ResourceResolver resourceResolver) {
        String[] searchPaths = resourceResolver.getSearchPath();
        for (int i = 0; i < searchPaths.length; ++i) {
            searchPaths[i] = searchPaths[i].substring(0, searchPaths[i].length() - 1);
        }
        HashMap<String, EmbeddableDescription> map = new HashMap<String, EmbeddableDescription>();
        ArrayList<String> disabledComponents = new ArrayList<String>();
        for (String path : searchPaths) {
            StringBuilder queryStringBuilder = new StringBuilder("/jcr:root");
            queryStringBuilder.append(path);
            queryStringBuilder.append("//* [@");
            queryStringBuilder.append("sling:resourceSuperType");
            queryStringBuilder.append("='");
            queryStringBuilder.append("core/wcm/components/embed/v1/embed/embeddable");
            queryStringBuilder.append("']");
            Iterator resourceIterator = resourceResolver.findResources(queryStringBuilder.toString(), "xpath");
            while (resourceIterator.hasNext()) {
                Resource embeddableResource = (Resource)resourceIterator.next();
                ValueMap properties = ResourceUtil.getValueMap((Resource)embeddableResource);
                String resourceType = embeddableResource.getPath().substring(path.length() + 1);
                if (((Boolean)properties.get(COMPONENT_PROPERTY_ENABLED, (Object)Boolean.TRUE)).booleanValue()) {
                    if (map.containsKey(resourceType) || disabledComponents.contains(resourceType)) continue;
                    map.put(resourceType, new EmbeddableDescription(resourceType, embeddableResource.getName(), properties));
                    continue;
                }
                disabledComponents.add(resourceType);
            }
        }
        ArrayList<EmbeddableDescription> entries = new ArrayList<EmbeddableDescription>(map.values());
        Collections.sort(entries);
        return entries;
    }

    public static class EmbeddableDescription
    implements Comparable<EmbeddableDescription> {
        private final String resourceType;
        private final String title;
        private final int order;

        public EmbeddableDescription(String rt, String defaultName, ValueMap properties) {
            this.resourceType = rt;
            this.title = (String)properties.get("jcr:title", (Object)defaultName);
            this.order = (Integer)properties.get(EmbeddablesDataSourceServlet.COMPONENT_PROPERTY_ORDER, (Object)0);
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public String getTitle() {
            return this.title;
        }

        @Override
        public int compareTo(@NotNull EmbeddableDescription o) {
            if (this.order < o.order) {
                return -1;
            }
            if (this.order == o.order) {
                return this.title.compareTo(o.title);
            }
            return 1;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.compareTo((EmbeddableDescription)obj) == 0;
        }

        public int hashCode() {
            return this.title.hashCode() + this.title.hashCode();
        }
    }

    public static class EmbeddableDataResourceSource
    extends TextValueDataResourceSource {
        private final EmbeddableDescription description;

        EmbeddableDataResourceSource(EmbeddableDescription description, ResourceResolver resourceResolver) {
            super(resourceResolver, "", "sling:nonexisting");
            this.description = description;
        }

        @Override
        public String getText() {
            return this.description.getTitle();
        }

        @Override
        public String getValue() {
            return this.description.getResourceType();
        }
    }
}

