/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.util;

import com.adobe.cq.wcm.core.components.internal.DataLayerConfig;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.components.ComponentContext;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.ConfigurationBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComponentUtils {
    public static final String NN_SLING_CONFIGS = "sling:configs";
    public static final String ID_SEPARATOR = "-";
    private static final int ID_HASH_LENGTH = 10;

    private ComponentUtils() {
    }

    public static boolean isDataLayerEnabled(@NotNull Resource resource) {
        return Optional.ofNullable(resource.adaptTo(ConfigurationBuilder.class)).map(builder -> (DataLayerConfig)builder.as(DataLayerConfig.class)).map(DataLayerConfig::enabled).orElse(false);
    }

    @NotNull
    public static String getId(@NotNull Resource resource, @Nullable Page currentPage, @Nullable ComponentContext componentContext) {
        return ComponentUtils.getPropertyId(resource).orElseGet(() -> ComponentUtils.generateId(resource, currentPage, componentContext));
    }

    private static Optional<String> getPropertyId(@NotNull Resource resource) {
        return Optional.ofNullable(resource.getValueMap().get("id", String.class)).filter(StringUtils::isNotEmpty).map(StringUtils::trim).map(StringUtils::normalizeSpace).map(val -> StringUtils.replace((String)val, (String)" ", (String)ID_SEPARATOR));
    }

    @NotNull
    private static String generateId(@NotNull Resource resource, @Nullable Page currentPage, @Nullable ComponentContext componentContext) {
        String resourceType = resource.getResourceType();
        String prefix = StringUtils.substringAfterLast((String)resourceType, (String)"/");
        String path = resource.getPath();
        if (currentPage != null && componentContext != null) {
            boolean inTemplate;
            PageManager pageManager = currentPage.getPageManager();
            Page resourcePage = pageManager.getContainingPage(resource);
            Template template = currentPage.getTemplate();
            boolean inCurrentPage = resourcePage != null && StringUtils.equals((CharSequence)resourcePage.getPath(), (CharSequence)currentPage.getPath());
            boolean bl = inTemplate = template != null && path.startsWith(template.getPath());
            if (!inCurrentPage && !inTemplate) {
                for (ComponentContext parentContext = componentContext.getParent(); parentContext != null; parentContext = parentContext.getParent()) {
                    Resource parentContextResource = parentContext.getResource();
                    if (parentContextResource == null) continue;
                    Page parentContextPage = pageManager.getContainingPage(parentContextResource);
                    inCurrentPage = parentContextPage != null && StringUtils.equals((CharSequence)parentContextPage.getPath(), (CharSequence)currentPage.getPath());
                    boolean bl2 = inTemplate = template != null && parentContextResource.getPath().startsWith(template.getPath());
                    if (!inCurrentPage && !inTemplate) continue;
                    path = parentContextResource.getPath().concat(resource.getPath());
                    break;
                }
            }
        }
        return ComponentUtils.generateId(prefix, path);
    }

    @NotNull
    public static String generateId(@NotNull String prefix, @NotNull String path) {
        return StringUtils.join((Object[])new String[]{prefix, ID_SEPARATOR, StringUtils.substring((String)DigestUtils.sha256Hex((String)path), (int)0, (int)10)});
    }
}

