/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.commons.editor.dialog.inherited;

import com.adobe.cq.wcm.core.components.internal.Utils;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class InheritedField {
    private static final Logger log = LoggerFactory.getLogger(InheritedField.class);
    private static final String OVERRIDE_SUFFIX = "_override";
    private static final boolean OVERRIDE_DEFAULT = false;
    @Self
    private SlingHttpServletRequest slingRequest;
    @ValueMapValue
    private String prop;
    @ValueMapValue(name="granite:class")
    private String attrClass;
    @ValueMapValue
    private String heading;
    private String path;
    private Page containingPage;
    private String inheritedValue;
    private String specifiedValue;
    private boolean override;

    @PostConstruct
    private void initModel() {
        this.path = this.slingRequest.getRequestPathInfo().getSuffix();
        if (StringUtils.isBlank((CharSequence)this.path)) {
            RequestParameter itemParam = this.slingRequest.getRequestParameter("item");
            if (itemParam == null) {
                log.error("Suffix and 'item' param are blank");
                return;
            }
            this.path = itemParam.getString();
        }
        if (StringUtils.isBlank((CharSequence)this.prop)) {
            log.error("'prop' value is null");
            return;
        }
        ResourceResolver rr = this.slingRequest.getResourceResolver();
        PageManager pm = (PageManager)rr.adaptTo(PageManager.class);
        if (pm == null) {
            log.error("pagemanager is null");
            return;
        }
        this.containingPage = pm.getPage(this.path);
        if (this.containingPage == null) {
            log.error("page is null");
            return;
        }
        this.inheritedValue = Utils.getInheritedValue(this.containingPage.getParent(), this.prop);
        Resource contentResource = this.containingPage.getContentResource();
        if (contentResource == null) {
            return;
        }
        ValueMap props = (ValueMap)contentResource.adaptTo(ValueMap.class);
        if (props == null) {
            return;
        }
        this.override = (Boolean)props.get(this.getProp() + OVERRIDE_SUFFIX, (Object)false);
        this.specifiedValue = (String)props.get(this.getProp(), String.class);
    }

    public String getProp() {
        return this.prop;
    }

    public String getAttrClass() {
        return this.attrClass;
    }

    public String getHeading() {
        return this.heading;
    }

    public String getInheritedValue() {
        return this.inheritedValue;
    }

    public String getSpecifiedValue() {
        return this.specifiedValue;
    }

    public boolean isOverride() {
        return this.override;
    }
}

