/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal;

import com.adobe.cq.dam.cfm.ContentElement;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.FragmentTemplate;
import com.adobe.cq.export.json.ComponentExporter;
import com.day.cq.wcm.api.policies.ContentPolicy;
import com.day.cq.wcm.api.policies.ContentPolicyManager;
import com.day.text.Text;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.models.factory.ModelFactory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentFragmentUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ContentFragmentUtils.class);
    protected static final String DEFAULT_GRID_TYPE = "dam/cfm/components/grid";
    protected static final String PN_CFM_GRID_TYPE = "cfm-grid-type";
    public static final String ATTR_RESOURCE_CALLER_PATH = "resourceCallerPath";

    private ContentFragmentUtils() {
    }

    public static String getType(ContentFragment contentFragment) {
        String type = "";
        if (contentFragment == null) {
            return type;
        }
        Resource fragmentResource = (Resource)contentFragment.adaptTo(Resource.class);
        FragmentTemplate fragmentTemplate = contentFragment.getTemplate();
        if (fragmentTemplate == null) {
            return type;
        }
        Resource templateResource = (Resource)fragmentTemplate.adaptTo(Resource.class);
        if (fragmentResource == null || templateResource == null) {
            LOG.warn("Unable to return type: fragment or template resource is null");
            type = contentFragment.getName();
        } else {
            Resource data;
            Resource parent = templateResource.getParent();
            if ("jcr:content".equals(templateResource.getName()) && parent != null) {
                templateResource = parent;
            }
            if ((data = fragmentResource.getChild("jcr:content/data")) == null || data.getValueMap().get((Object)"cq:model") == null) {
                type = templateResource.getPath();
            } else {
                StringBuilder prefix = new StringBuilder();
                String[] segments = Text.explode((String)templateResource.getPath(), (int)47, (boolean)false);
                for (int i = 1; i < segments.length - 5; ++i) {
                    prefix.append(segments[i]);
                    prefix.append("/");
                }
                type = prefix.toString() + "models/" + templateResource.getName();
            }
        }
        return type;
    }

    public static Iterator<ContentElement> filterElements(ContentFragment contentFragment, String[] elementNames) {
        if (ArrayUtils.isNotEmpty((Object[])elementNames)) {
            LinkedList<ContentElement> elements = new LinkedList<ContentElement>();
            for (String name : elementNames) {
                if (!contentFragment.hasElement(name)) {
                    LOG.warn("Skipping non-existing element '{}'", (Object)name);
                    continue;
                }
                elements.add(contentFragment.getElement(name));
            }
            return elements.iterator();
        }
        return contentFragment.getElements();
    }

    public static String getEditorJSON(ContentFragment contentFragment, String variationName, String[] elementNames) {
        Iterator associatedContentIterator;
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("title", contentFragment.getTitle());
        Resource contentFragmentResource = (Resource)contentFragment.adaptTo(Resource.class);
        if (contentFragmentResource != null) {
            jsonObjectBuilder.add("path", contentFragmentResource.getPath());
        }
        if (variationName != null) {
            jsonObjectBuilder.add("variation", variationName);
        }
        if (elementNames != null) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (String elementName : elementNames) {
                arrayBuilder.add(elementName);
            }
            jsonObjectBuilder.add("elements", arrayBuilder);
        }
        if ((associatedContentIterator = contentFragment.getAssociatedContent()).hasNext()) {
            JsonArrayBuilder associatedContentArray = Json.createArrayBuilder();
            while (associatedContentIterator.hasNext()) {
                Resource resource = (Resource)associatedContentIterator.next();
                ValueMap valueMap = (ValueMap)resource.adaptTo(ValueMap.class);
                JsonObjectBuilder contentObject = Json.createObjectBuilder();
                if (valueMap != null && valueMap.containsKey((Object)"jcr:title")) {
                    contentObject.add("title", (String)valueMap.get("jcr:title", String.class));
                }
                contentObject.add("path", resource.getPath());
                associatedContentArray.add(contentObject);
            }
            jsonObjectBuilder.add("associatedContent", associatedContentArray);
        }
        return jsonObjectBuilder.build().toString();
    }

    public static String getGridResourceType(Resource fragmentResource) {
        ContentPolicy fragmentContentPolicy;
        String gridResourceType = DEFAULT_GRID_TYPE;
        if (fragmentResource == null) {
            return gridResourceType;
        }
        ResourceResolver resourceResolver = fragmentResource.getResourceResolver();
        ContentPolicyManager contentPolicyManager = (ContentPolicyManager)resourceResolver.adaptTo(ContentPolicyManager.class);
        ContentPolicy contentPolicy = fragmentContentPolicy = contentPolicyManager != null ? contentPolicyManager.getPolicy(fragmentResource) : null;
        if (fragmentContentPolicy != null) {
            ValueMap contentPolicyProperties = fragmentContentPolicy.getProperties();
            gridResourceType = (String)contentPolicyProperties.get(PN_CFM_GRID_TYPE, (Object)DEFAULT_GRID_TYPE);
        }
        return gridResourceType;
    }

    public static String[] getItemsOrder(Map<String, ?> itemsMap) {
        if (itemsMap == null || itemsMap.isEmpty()) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return itemsMap.keySet().toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    @NotNull
    public static LinkedHashMap<String, ComponentExporter> getComponentExporters(@NotNull Iterator<Resource> resourceIterator, @NotNull ModelFactory modelFactory, @NotNull SlingHttpServletRequest slingHttpServletRequest, final @NotNull Resource callerResource) {
        LinkedHashMap<String, ComponentExporter> componentExporterMap = new LinkedHashMap<String, ComponentExporter>();
        SlingHttpServletRequestWrapper wrappedSlingHttpServletRequest = new SlingHttpServletRequestWrapper(slingHttpServletRequest){

            public Object getAttribute(String name) {
                if (ContentFragmentUtils.ATTR_RESOURCE_CALLER_PATH.equals(name)) {
                    String resourceCallerPath = (String)super.getAttribute(ContentFragmentUtils.ATTR_RESOURCE_CALLER_PATH);
                    return resourceCallerPath != null ? resourceCallerPath : callerResource.getPath();
                }
                return super.getAttribute(name);
            }
        };
        while (resourceIterator.hasNext()) {
            String name;
            Resource resource = resourceIterator.next();
            ComponentExporter exporter = (ComponentExporter)modelFactory.getModelFromWrappedRequest((SlingHttpServletRequest)wrappedSlingHttpServletRequest, resource, ComponentExporter.class);
            if (exporter == null || componentExporterMap.put(name = resource.getName(), exporter) == null) continue;
            throw new IllegalStateException(String.format("Duplicate key '%s'", name));
        }
        return componentExporterMap;
    }
}

