/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal;

import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.internal.link.LinkHandler;
import com.adobe.cq.wcm.core.components.internal.resource.CoreResourceWrapper;
import com.adobe.cq.wcm.core.components.models.ExperienceFragment;
import com.adobe.cq.wcm.core.components.util.ComponentUtils;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.designer.Style;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.factory.ModelFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    private static final Set<String> INTERNAL_PARAMETER = ImmutableSet.of((Object)":formstart", (Object)"_charset_", (Object)":redirect", (Object)":cq_csrf_token");
    public static final String COMPONENTS_SERVICE = "components-service";

    private Utils() {
    }

    @NotNull
    public static Set<String> getPageResourceTypes(@NotNull Page page, @NotNull SlingHttpServletRequest request, @NotNull ModelFactory modelFactory) {
        HashSet<String> resourceTypes = new HashSet<String>();
        resourceTypes.addAll(Utils.getResourceTypes(page.getContentResource(), request, modelFactory));
        resourceTypes.addAll(Utils.getTemplateResourceTypes(page, request, modelFactory));
        return resourceTypes;
    }

    @NotNull
    public static Set<String> getResourceTypes(@NotNull Resource resource, @NotNull SlingHttpServletRequest request, @NotNull ModelFactory modelFactory) {
        HashSet<String> resourceTypes = new HashSet<String>();
        resourceTypes.add(resource.getResourceType());
        resourceTypes.addAll(Utils.getXFResourceTypes(resource, request, modelFactory));
        for (Resource child : resource.getChildren()) {
            resourceTypes.addAll(Utils.getResourceTypes(child, request, modelFactory));
        }
        return resourceTypes;
    }

    @NotNull
    public static Set<String> getXFResourceTypes(@NotNull Resource resource, @NotNull SlingHttpServletRequest request, @NotNull ModelFactory modelFactory) {
        Resource fragmentResource;
        String fragmentPath;
        ExperienceFragment experienceFragment = (ExperienceFragment)modelFactory.getModelFromWrappedRequest(request, resource, ExperienceFragment.class);
        if (experienceFragment != null && StringUtils.isNotEmpty((CharSequence)(fragmentPath = experienceFragment.getLocalizedFragmentVariationPath())) && (fragmentResource = resource.getResourceResolver().getResource(fragmentPath)) != null) {
            return Utils.getResourceTypes(fragmentResource, request, modelFactory);
        }
        return Collections.emptySet();
    }

    @NotNull
    public static Set<String> getTemplateResourceTypes(@NotNull Page page, @NotNull SlingHttpServletRequest request, @NotNull ModelFactory modelFactory) {
        Template template = page.getTemplate();
        if (template != null) {
            String templatePath = template.getPath() + "/structure/jcr:content/";
            Resource templateResource = request.getResourceResolver().getResource(templatePath);
            if (templateResource != null) {
                return Utils.getResourceTypes(templateResource, request, modelFactory);
            }
        }
        return Collections.emptySet();
    }

    @NotNull
    public static Set<String> getSuperTypes(@NotNull String resourceType, @NotNull ResourceResolver resourceResolver) {
        HashSet<String> superTypes = new HashSet<String>();
        String superType = resourceType;
        while (superType != null) {
            if ((superType = (String)Optional.ofNullable(resourceResolver.getResource(superType)).map(Resource::getResourceSuperType).filter(StringUtils::isNotEmpty).orElse(null)) == null) continue;
            superTypes.add(superType);
        }
        return superTypes;
    }

    @NotNull
    public static String getInheritedValue(Page startPage, String propertyName) {
        if (startPage == null) {
            return "";
        }
        Page tmp = startPage;
        while (tmp != null && tmp.hasContent() && tmp.getDepth() > 1) {
            ValueMap props = tmp.getProperties();
            if (props == null) continue;
            boolean override = Boolean.parseBoolean((String)props.get(propertyName + "_override", String.class));
            if (override) {
                return (String)props.get(propertyName, (Object)"");
            }
            tmp = tmp.getParent();
        }
        return "";
    }

    @NotNull
    public static Set<String> getStrings(@Nullable Object input) {
        LinkedHashSet<String> strings;
        block3: {
            Class<?> clazz;
            block5: {
                block4: {
                    strings = new LinkedHashSet<String>();
                    if (input == null) break block3;
                    clazz = input.getClass();
                    if (!Collection.class.isAssignableFrom(clazz)) break block4;
                    for (Object obj : (Collection)input) {
                        if (obj == null) continue;
                        strings.add(obj.toString());
                    }
                    break block3;
                }
                if (!Object[].class.isAssignableFrom(clazz)) break block5;
                for (Object obj : (Object[])input) {
                    if (obj == null) continue;
                    strings.add(obj.toString());
                }
                break block3;
            }
            if (!String.class.isAssignableFrom(clazz)) break block3;
            for (String str : ((String)input).split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)str)) continue;
                strings.add(str.trim());
            }
        }
        return strings;
    }

    public static JSONObject getJsonOfRequestParameters(SlingHttpServletRequest request) throws JSONException {
        JSONObject jsonObj = new JSONObject();
        Map params = request.getParameterMap();
        for (Map.Entry entry : params.entrySet()) {
            if (INTERNAL_PARAMETER.contains(entry.getKey())) continue;
            String[] v = (String[])entry.getValue();
            String[] o = v.length == 1 ? v[0] : v;
            jsonObj.put((String)entry.getKey(), (Object)o);
        }
        return jsonObj;
    }

    public static <T> T getPropertyOrStyle(Resource resource, String property, Class<T> type) {
        ValueMap properties = resource.getValueMap();
        Object value = properties.get(property, type);
        if (value == null) {
            Style style;
            Designer designer = (Designer)resource.getResourceResolver().adaptTo(Designer.class);
            Style style2 = style = designer != null ? designer.getStyle(resource) : null;
            if (style != null) {
                value = style.get(property, type);
            }
        }
        return (T)value;
    }

    public static Resource getWrappedImageResourceWithInheritance(Resource resource, LinkHandler linkHandler) {
        if (resource == null) {
            LOGGER.error("The resource is not defined");
            return null;
        }
        ResourceResolver resourceResolver = resource.getResourceResolver();
        ValueMap properties = resource.getValueMap();
        String fileReference = (String)properties.get("fileReference", String.class);
        Resource fileResource = resource.getChild("file");
        boolean imageFromPageImage = (Boolean)properties.get("imageFromPageImage", (Object)(StringUtils.isEmpty((CharSequence)fileReference) && fileResource == null ? 1 : 0));
        boolean altValueFromPageImage = (Boolean)properties.get("altValueFromPageImage", (Object)imageFromPageImage);
        if (imageFromPageImage) {
            Resource inheritedResource = null;
            if (linkHandler != null) {
                Optional<Link> link = linkHandler.getLink(resource);
                if (link.isPresent()) {
                    Page linkedPage = (Page)link.get().getReference();
                    if (linkedPage != null) {
                        inheritedResource = ComponentUtils.getFeaturedImage(linkedPage);
                    }
                } else {
                    Page page;
                    PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
                    if (pageManager != null && (page = pageManager.getContainingPage(resource)) != null) {
                        inheritedResource = ComponentUtils.getFeaturedImage(page);
                    }
                }
            }
            String inheritedFileReference = null;
            Resource inheritedFileResource = null;
            String inheritedAlt = null;
            String inheritedAltValueFromDAM = null;
            if (inheritedResource != null) {
                ValueMap inheritedProperties = inheritedResource.getValueMap();
                inheritedFileReference = (String)inheritedProperties.get("fileReference", String.class);
                inheritedFileResource = inheritedResource.getChild("file");
                inheritedAlt = (String)inheritedProperties.get("alt", String.class);
                inheritedAltValueFromDAM = (String)inheritedProperties.get("altValueFromDAM", String.class);
            }
            ArrayList<String> hiddenProperties = new ArrayList<String>();
            HashMap<String, String> overriddenProperties = new HashMap<String, String>();
            HashMap<String, Resource> overriddenChildren = new HashMap<String, Resource>();
            overriddenProperties.put("fileReference", inheritedFileReference);
            overriddenChildren.put("file", inheritedFileResource);
            overriddenProperties.put("titleValueFromDAM", "false");
            if (altValueFromPageImage) {
                overriddenProperties.put("alt", inheritedAlt);
                overriddenProperties.put("altValueFromDAM", inheritedAltValueFromDAM);
            } else {
                overriddenProperties.put("altValueFromDAM", "false");
            }
            return new CoreResourceWrapper(resource, resource.getResourceType(), hiddenProperties, overriddenProperties, overriddenChildren);
        }
        return resource;
    }
}

