/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.link;

import com.adobe.cq.wcm.core.components.services.link.PathProcessor;
import com.day.cq.commons.Externalizer;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Designate(ocd=Config.class)
@Component(property={"service.ranking:Integer=-2147483648"}, service={PathProcessor.class})
public class DefaultPathProcessor
implements PathProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPathProcessor.class);
    @Reference
    Externalizer externalizer;
    private VanityConfig vanityConfig;

    @Activate
    protected void activate(BundleContext bundleContext, Config config) {
        this.vanityConfig = VanityConfig.fromString(config.vanityConfig());
    }

    @Override
    public boolean accepts(@NotNull String path, @NotNull SlingHttpServletRequest request) {
        return true;
    }

    @Override
    @NotNull
    public String sanitize(@NotNull String path, @NotNull SlingHttpServletRequest request) {
        String fragmentQuery;
        int fragmentQueryMark;
        if (this.vanityConfig == VanityConfig.ALWAYS) {
            path = this.getPathOrVanityUrl(path, request.getResourceResolver());
        }
        if ((fragmentQueryMark = path.indexOf(35)) < 0) {
            fragmentQueryMark = path.indexOf(63);
        }
        if (fragmentQueryMark >= 0) {
            fragmentQuery = path.substring(fragmentQueryMark);
            path = path.substring(0, fragmentQueryMark);
        } else {
            fragmentQuery = null;
        }
        String cp = request.getContextPath();
        if (!StringUtils.isEmpty((CharSequence)cp) && path.startsWith("/") && !path.startsWith(cp + "/")) {
            path = cp + path;
        }
        try {
            URI uri = new URI(path, false);
            path = uri.toString();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        if (fragmentQuery != null) {
            path = path + fragmentQuery;
        }
        return path;
    }

    @Override
    @NotNull
    public String map(@NotNull String path, @NotNull SlingHttpServletRequest request) {
        String mappedPath;
        ResourceResolver resourceResolver = request.getResourceResolver();
        try {
            mappedPath = this.vanityConfig == VanityConfig.MAPPING || this.vanityConfig == VanityConfig.ALWAYS ? StringUtils.defaultString((String)resourceResolver.map((HttpServletRequest)request, this.getPathOrVanityUrl(path, resourceResolver))) : StringUtils.defaultString((String)resourceResolver.map((HttpServletRequest)request, path));
        }
        catch (Exception e) {
            mappedPath = path;
        }
        return mappedPath;
    }

    @Override
    @NotNull
    public String externalize(@NotNull String path, @NotNull SlingHttpServletRequest request) {
        String externalPath;
        ResourceResolver resourceResolver = request.getResourceResolver();
        try {
            externalPath = this.vanityConfig == VanityConfig.MAPPING || this.vanityConfig == VanityConfig.ALWAYS ? this.externalizer.publishLink(resourceResolver, this.getPathOrVanityUrl(path, resourceResolver)) : this.externalizer.publishLink(resourceResolver, path);
        }
        catch (Exception e) {
            externalPath = path;
        }
        return externalPath;
    }

    @NotNull
    private String getPathOrVanityUrl(@NotNull String path, @NotNull ResourceResolver resourceResolver) {
        return Optional.ofNullable(this.getVanityUrl(path, resourceResolver)).filter(StringUtils::isNotBlank).orElse(path);
    }

    @Nullable
    private String getVanityUrl(@NotNull String path, @NotNull ResourceResolver resourceResolver) {
        Page page;
        PageManager pageManager;
        String vanityUrl = null;
        if (path.endsWith(".html") && (pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class)) != null && (page = pageManager.getPage(path.substring(0, path.lastIndexOf(".html")))) != null && StringUtils.isNotBlank((CharSequence)(vanityUrl = page.getVanityUrl())) && !vanityUrl.startsWith("/")) {
            vanityUrl = "/" + vanityUrl;
        }
        return vanityUrl;
    }

    public static enum VanityConfig {
        NEVER("never"),
        ALWAYS("always"),
        MAPPING("mapping");

        private String value;

        public String getValue() {
            return this.value;
        }

        private VanityConfig(String value) {
            this.value = value;
        }

        public static VanityConfig fromString(String value) {
            for (VanityConfig config : VanityConfig.values()) {
                if (!StringUtils.equals((CharSequence)config.value, (CharSequence)value)) continue;
                return config;
            }
            return NEVER;
        }
    }

    @ObjectClassDefinition(name="Core Components Default Path Processor")
    static @interface Config {
        @AttributeDefinition(name="Vanity path rewriting", description="Defines how the vanity url of a page is taken into account while generating the link URLs", options={@Option(label="never", value="never"), @Option(label="always", value="always"), @Option(label="on path mapping and externalization", value="mapping")})
        public String vanityConfig() default "never";
    }
}

