/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.internal.link.LinkHandler;
import com.adobe.cq.wcm.core.components.models.Button;
import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.ComponentDataBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.adobe.cq.wcm.core.components.util.AbstractComponentImpl;
import com.day.cq.wcm.api.PageManager;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.inject.Named;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Button.class, ComponentExporter.class}, resourceType={"core/wcm/components/button/v1/button"})
@Exporter(name="jackson", extensions={"json"})
public class ButtonImpl
extends AbstractComponentImpl
implements Button {
    public static final String RESOURCE_TYPE = "core/wcm/components/button/v1/button";
    @Self
    private SlingHttpServletRequest request;
    @ScriptVariable
    private Resource resource;
    @ScriptVariable
    private PageManager pageManager;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Named(value="jcr:title")
    @Nullable
    private String text;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    private String icon;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    protected String accessibilityLabel;
    @Self
    private LinkHandler linkHandler;
    protected Optional<Link> link;

    @PostConstruct
    private void initModel() {
        this.link = this.linkHandler.getLink(this.resource, "link");
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getLink() {
        return this.link.map(Link::getURL).orElse(null);
    }

    @Override
    @Nullable
    public String getIcon() {
        return this.icon;
    }

    @Override
    @Nullable
    public String getAccessibilityLabel() {
        return this.accessibilityLabel;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.request.getResource().getResourceType();
    }

    @Override
    @NotNull
    protected ComponentData getComponentData() {
        return ((ComponentDataBuilder)((ComponentDataBuilder)DataLayerBuilder.extending(super.getComponentData()).asComponent().withTitle(this::getText)).withLinkUrl(() -> this.link.map(Link::getMappedURL).orElse(null))).build();
    }
}

