/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v2;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.internal.models.v1.ImageAreaImpl;
import com.adobe.cq.wcm.core.components.models.Image;
import com.adobe.cq.wcm.core.components.models.ImageArea;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.scene7.api.constants.Scene7AssetType;
import com.day.cq.wcm.api.WCMMode;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Image.class, ComponentExporter.class}, resourceType={"core/wcm/components/image/v2/image"})
@Exporter(name="jackson", extensions={"json"})
public class ImageImpl
extends com.adobe.cq.wcm.core.components.internal.models.v1.ImageImpl
implements Image {
    @ValueMapValue(name="imageModifiers", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    protected String imageModifiers;
    @ValueMapValue(name="imagePreset", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    protected String imagePreset;
    @ValueMapValue(name="smartCropRendition", injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    protected String smartCropRendition;
    public static final String RESOURCE_TYPE = "core/wcm/components/image/v2/image";
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageImpl.class);
    private static final String SRC_URI_TEMPLATE_WIDTH_VAR = "{.width}";
    private static final String SMART_CROP_AUTO = "SmartCrop:Auto";
    private static final String CONTENT_POLICY_DELEGATE_PATH = "contentPolicyDelegatePath";
    private static final String DM_IMAGE_SERVER_PATH = "/is/image/";
    private static final String DM_CONTENT_SERVER_PATH = "/is/content/";
    protected String srcUriTemplate;
    protected List<ImageArea> areas;
    protected int lazyThreshold;
    protected boolean dmImage = false;
    protected String uuid;

    public ImageImpl() {
        this.selector = "coreimg";
    }

    @Override
    @PostConstruct
    protected void initModel() {
        super.initModel();
        boolean altValueFromDAM = (Boolean)this.properties.get("altValueFromDAM", this.currentStyle.get("altValueFromDAM", (Object)true));
        boolean titleValueFromDAM = (Boolean)this.properties.get("titleValueFromDAM", this.currentStyle.get("titleValueFromDAM", (Object)true));
        boolean isDmFeaturesEnabled = (Boolean)this.currentStyle.get("enableDmFeatures", (Object)false);
        this.displayPopupTitle = (Boolean)this.properties.get("displayPopupTitle", this.currentStyle.get("displayPopupTitle", (Object)true));
        boolean uuidDisabled = (Boolean)this.currentStyle.get("uuidDisabled", (Object)false);
        String dmImageUrl = null;
        if (StringUtils.isNotEmpty((CharSequence)this.fileReference)) {
            Resource assetResource = this.request.getResourceResolver().getResource(this.fileReference);
            if (assetResource != null) {
                Asset asset = (Asset)assetResource.adaptTo(Asset.class);
                if (asset != null) {
                    String damTitle;
                    this.uuid = !uuidDisabled ? asset.getID() : null;
                    if (!this.isDecorative && altValueFromDAM) {
                        String damDescription = asset.getMetadataValue("dc:description");
                        if (StringUtils.isEmpty((CharSequence)damDescription)) {
                            damDescription = asset.getMetadataValue("dc:title");
                        }
                        if (StringUtils.isNotEmpty((CharSequence)damDescription)) {
                            this.alt = damDescription;
                        }
                    }
                    if (titleValueFromDAM && StringUtils.isNotEmpty((CharSequence)(damTitle = asset.getMetadataValue("dc:title")))) {
                        this.title = damTitle;
                    }
                    String dmAssetName = asset.getMetadataValue("dam:scene7File");
                    if (isDmFeaturesEnabled && !StringUtils.isEmpty((CharSequence)dmAssetName)) {
                        this.dmImage = true;
                        boolean isWCMDisabled = WCMMode.fromRequest((ServletRequest)this.request) == WCMMode.DISABLED;
                        String dmServerPath = asset.getMetadataValue("dam:scene7Type").equals(Scene7AssetType.ANIMATED_GIF.getValue()) ? DM_CONTENT_SERVER_PATH : DM_IMAGE_SERVER_PATH;
                        String dmServerUrl = !isWCMDisabled ? dmServerPath : asset.getMetadataValue("dam:scene7Domain") + dmServerPath.substring(1);
                        dmImageUrl = dmServerUrl + dmAssetName;
                    }
                } else {
                    LOGGER.error("Unable to adapt resource '{}' used by image '{}' to an asset.", (Object)this.fileReference, (Object)this.request.getResource().getPath());
                }
            } else {
                LOGGER.error("Unable to find resource '{}' used by image '{}'.", (Object)this.fileReference, (Object)this.request.getResource().getPath());
            }
        }
        if (this.hasContent) {
            this.disableLazyLoading = (Boolean)this.currentStyle.get("disableLazyLoading", (Object)true);
            if (dmImageUrl == null) {
                String staticSelectors = this.selector;
                if (this.smartSizes.length > 0) {
                    staticSelectors = staticSelectors + "." + this.jpegQuality;
                }
                this.srcUriTemplate = this.baseResourcePath + "." + staticSelectors + SRC_URI_TEMPLATE_WIDTH_VAR + "." + this.extension + (this.inTemplate ? this.templateRelativePath : "") + (this.lastModifiedDate > 0L ? "/" + this.lastModifiedDate + (StringUtils.isNotBlank((CharSequence)this.imageName) ? "/" + this.imageName : "") : "") + (this.inTemplate || this.lastModifiedDate > 0L ? "." + this.extension : "");
                String policyDelegatePath = this.request.getParameter(CONTENT_POLICY_DELEGATE_PATH);
                if (StringUtils.isNotBlank((CharSequence)policyDelegatePath)) {
                    this.srcUriTemplate = this.srcUriTemplate + "?contentPolicyDelegatePath=" + policyDelegatePath;
                    this.src = this.src + "?contentPolicyDelegatePath=" + policyDelegatePath;
                }
            } else {
                this.srcUriTemplate = dmImageUrl;
                this.src = dmImageUrl;
                if (StringUtils.isNotBlank((CharSequence)this.smartCropRendition)) {
                    if (this.smartCropRendition.equals(SMART_CROP_AUTO)) {
                        this.srcUriTemplate = this.srcUriTemplate + SRC_URI_TEMPLATE_WIDTH_VAR;
                    } else {
                        this.srcUriTemplate = this.srcUriTemplate + "%3A" + this.smartCropRendition;
                        this.src = this.src + "%3A" + this.smartCropRendition;
                    }
                }
                if (this.smartSizes.length > 0 && StringUtils.isBlank((CharSequence)this.smartCropRendition)) {
                    String widCommand;
                    String qualityCommand = "?qlt=" + this.jpegQuality;
                    this.srcUriTemplate = this.srcUriTemplate + qualityCommand;
                    this.src = this.src + qualityCommand;
                    if (this.smartSizes.length == 1) {
                        widCommand = "&wid=" + this.smartSizes[0];
                        this.srcUriTemplate = this.srcUriTemplate + widCommand;
                        this.src = this.src + widCommand;
                    } else {
                        widCommand = "&wid=%7B.width%7D";
                        this.srcUriTemplate = this.srcUriTemplate + widCommand;
                    }
                }
                String suffix = "";
                if (this.lastModifiedDate > 0L) {
                    String timeStampCommand = (this.srcUriTemplate.contains("?") ? (char)'&' : '?') + "ts=" + this.lastModifiedDate;
                    this.srcUriTemplate = this.srcUriTemplate + timeStampCommand;
                    this.src = this.src + timeStampCommand;
                }
                if (StringUtils.isNotBlank((CharSequence)this.imagePreset) && StringUtils.isBlank((CharSequence)this.smartCropRendition)) {
                    String imagePresetCommand = (this.srcUriTemplate.contains("?") ? (char)'&' : '?') + "$" + this.imagePreset + "$";
                    this.srcUriTemplate = this.srcUriTemplate + imagePresetCommand;
                    this.src = this.src + imagePresetCommand;
                }
                if (StringUtils.isNotBlank((CharSequence)this.imageModifiers)) {
                    String imageModifiersCommand = (this.srcUriTemplate.contains("?") ? (char)'&' : '?') + this.imageModifiers;
                    this.srcUriTemplate = this.srcUriTemplate + imageModifiersCommand;
                    this.src = this.src + imageModifiersCommand;
                }
                String dprOffParameter = (this.srcUriTemplate.contains("?") ? (char)'&' : '?') + "dpr=off";
                this.srcUriTemplate = this.srcUriTemplate + dprOffParameter;
                this.src = this.src + dprOffParameter;
                if (this.srcUriTemplate.equals(this.src)) {
                    this.srcUriTemplate = null;
                }
            }
            this.buildAreas();
            this.buildJson();
        }
        this.lazyThreshold = (Integer)this.currentStyle.get("lazyThreshold", (Object)0);
    }

    @Override
    public int @NotNull [] getWidths() {
        return Arrays.copyOf(this.smartSizes, this.smartSizes.length);
    }

    @Override
    public String getSrcUriTemplate() {
        return this.srcUriTemplate;
    }

    @Override
    public boolean isLazyEnabled() {
        return !this.disableLazyLoading;
    }

    @Override
    public boolean isDmImage() {
        return this.dmImage;
    }

    @Override
    public String getSmartCropRendition() {
        return this.smartCropRendition;
    }

    @Override
    public int getLazyThreshold() {
        return this.lazyThreshold;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<ImageArea> getAreas() {
        if (this.areas == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.areas);
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    protected void buildAreas() {
        this.areas = new ArrayList<ImageArea>();
        String mapProperty = (String)this.properties.get("imageMap", String.class);
        if (StringUtils.isNotEmpty((CharSequence)mapProperty)) {
            String area;
            int coordinatesEndIndex;
            String[] mapAreas;
            String[] stringArray = mapAreas = StringUtils.split((String)mapProperty, (String)"][");
            int n = stringArray.length;
            for (int i = 0; i < n && (coordinatesEndIndex = (area = stringArray[i]).indexOf(41)) >= 0; ++i) {
                String target;
                String shapeAndCoords = StringUtils.substring((String)area, (int)0, (int)(coordinatesEndIndex + 1));
                String shape = StringUtils.substringBefore((String)shapeAndCoords, (String)"(");
                String coordinates = StringUtils.substringBetween((String)shapeAndCoords, (String)"(", (String)")");
                String remaining = StringUtils.substring((String)area, (int)(coordinatesEndIndex + 1));
                String[] remainingTokens = StringUtils.split((String)remaining, (String)"|");
                if (StringUtils.isBlank((CharSequence)shape) || StringUtils.isBlank((CharSequence)coordinates)) break;
                if (remainingTokens.length <= 0) continue;
                String href = StringUtils.removeAll((String)remainingTokens[0], (String)"\"");
                Link link = this.linkHandler.getLink(href, target = remainingTokens.length > 1 ? StringUtils.removeAll((String)remainingTokens[1], (String)"\"") : "").orElse(null);
                if (link == null || !link.isValid()) break;
                String alt = remainingTokens.length > 2 ? StringUtils.removeAll((String)remainingTokens[2], (String)"\"") : "";
                String relativeCoordinates = remainingTokens.length > 3 ? remainingTokens[3] : "";
                relativeCoordinates = StringUtils.substringBetween((String)relativeCoordinates, (String)"(", (String)")");
                this.areas.add(this.newImageArea(shape, coordinates, relativeCoordinates, link, alt));
            }
        }
    }

    protected ImageArea newImageArea(String shape, String coordinates, String relativeCoordinates, @NotNull Link link, String alt) {
        return new ImageAreaImpl(shape, coordinates, relativeCoordinates, link, alt);
    }
}

