/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v2;

import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.internal.link.LinkHandler;
import com.adobe.cq.wcm.core.components.internal.resource.CoreResourceWrapper;
import com.adobe.cq.wcm.core.components.models.datalayer.PageData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.PageDataBuilder;
import com.adobe.cq.wcm.core.components.util.ComponentUtils;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.components.Component;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageListItemImpl
extends com.adobe.cq.wcm.core.components.internal.models.v1.PageListItemImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageListItemImpl.class);
    private final Component component;
    private Resource teaserResource;
    private boolean showDescription;
    private boolean linkItems;
    private Map<String, String> overriddenProperties = new HashMap<String, String>();
    private List<String> hiddenProperties = new ArrayList<String>();

    public PageListItemImpl(@NotNull LinkHandler linkHandler, @NotNull Page page, String parentId, Component component) {
        super(linkHandler, page, parentId, component);
        this.component = component;
    }

    public PageListItemImpl(@NotNull LinkHandler linkHandler, @NotNull Page page, String parentId, Component component, boolean showDescription, boolean linkItems) {
        super(linkHandler, page, parentId, component);
        this.component = component;
        this.showDescription = showDescription;
        this.linkItems = linkItems;
    }

    @Override
    @JsonIgnore(value=false)
    @Nullable
    public Link<Page> getLink() {
        return super.getLink();
    }

    @Override
    @JsonIgnore
    @Deprecated
    public String getURL() {
        return super.getURL();
    }

    @Override
    @JsonIgnore
    public Resource getTeaserResource() {
        if (this.teaserResource == null && this.component != null) {
            String delegateResourceType = (String)this.component.getProperties().get("teaserDelegate", String.class);
            if (StringUtils.isEmpty((CharSequence)delegateResourceType)) {
                LOGGER.error("In order for list rendering delegation to work correctly you need to set up the teaserDelegate property on the {} component; its value has to point to the resource type of a teaser component.", (Object)this.component.getPath());
            } else {
                Resource resourceToBeWrapped = ComponentUtils.getFeaturedImage(this.page);
                if (resourceToBeWrapped != null) {
                    this.overriddenProperties.put("jcr:title", this.getTitle());
                    if (this.showDescription) {
                        this.overriddenProperties.put("jcr:description", this.getDescription());
                    }
                    if (this.linkItems) {
                        this.overriddenProperties.put("linkURL", this.getPath());
                    }
                } else {
                    resourceToBeWrapped = this.page.getContentResource();
                    if (resourceToBeWrapped == null) {
                        return null;
                    }
                    if (!this.showDescription) {
                        this.hiddenProperties.add("jcr:description");
                    }
                    if (this.linkItems) {
                        this.overriddenProperties.put("linkURL", this.getPath());
                    }
                }
                this.teaserResource = new CoreResourceWrapper(resourceToBeWrapped, delegateResourceType, this.hiddenProperties, this.overriddenProperties);
            }
        }
        return this.teaserResource;
    }

    @Override
    @NotNull
    protected PageData getComponentData() {
        return ((PageDataBuilder)((PageDataBuilder)DataLayerBuilder.extending(super.getComponentData()).asPage().withTitle(this::getTitle)).withLinkUrl(() -> this.link.map(Link::getMappedURL).orElse(null))).build();
    }
}

