/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v3;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.internal.Utils;
import com.adobe.cq.wcm.core.components.internal.models.v2.ImageAreaImpl;
import com.adobe.cq.wcm.core.components.internal.servlets.EnhancedRendition;
import com.adobe.cq.wcm.core.components.models.Image;
import com.adobe.cq.wcm.core.components.models.ImageArea;
import com.day.cq.dam.api.Asset;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.awt.Dimension;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Image.class, ComponentExporter.class}, resourceType={"core/wcm/components/image/v3/image"})
@Exporter(name="jackson", extensions={"json"})
public class ImageImpl
extends com.adobe.cq.wcm.core.components.internal.models.v2.ImageImpl
implements Image {
    public static final String RESOURCE_TYPE = "core/wcm/components/image/v3/image";
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageImpl.class);

    @Override
    @PostConstruct
    protected void initModel() {
        super.initModel();
        if (this.hasContent) {
            this.disableLazyLoading = (Boolean)this.currentStyle.get("disableLazyLoading", (Object)false);
        }
    }

    @Override
    @Nullable
    public Link getImageLink() {
        return this.link.orElse(null);
    }

    @Override
    @JsonIgnore
    @Deprecated
    public String getLink() {
        return super.getLink();
    }

    @Override
    protected ImageArea newImageArea(String shape, String coordinates, String relativeCoordinates, @NotNull Link link, String alt) {
        return new ImageAreaImpl(shape, coordinates, relativeCoordinates, link, alt);
    }

    @Override
    public String getSrcset() {
        int[] widthsArray = this.getWidths();
        String srcUritemplate = this.getSrcUriTemplate();
        Object[] srcsetArray = new String[widthsArray.length];
        if (widthsArray.length > 0 && srcUritemplate != null) {
            String srcUriTemplateDecoded = "";
            try {
                srcUriTemplateDecoded = URLDecoder.decode(srcUritemplate, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("Character Decoding failed for " + this.resource.getPath());
            }
            if (srcUriTemplateDecoded.contains("{.width}")) {
                for (int i = 0; i < widthsArray.length; ++i) {
                    srcsetArray[i] = srcUriTemplateDecoded.contains("={.width}") ? srcUriTemplateDecoded.replace("{.width}", String.format("%s", widthsArray[i])) + " " + widthsArray[i] + "w" : srcUriTemplateDecoded.replace("{.width}", String.format(".%s", widthsArray[i])) + " " + widthsArray[i] + "w";
                }
                return StringUtils.join((Object[])srcsetArray, (char)',');
            }
        }
        return null;
    }

    @Override
    @JsonIgnore
    @Nullable
    public String getHeight() {
        int height = this.getOriginalDimension().height;
        if (height > 0) {
            return String.valueOf(height);
        }
        return null;
    }

    @Override
    @JsonIgnore
    @Nullable
    public String getWidth() {
        int width = this.getOriginalDimension().width;
        if (width > 0) {
            return String.valueOf(width);
        }
        return null;
    }

    @Override
    @JsonIgnore
    public String getSrcUriTemplate() {
        return super.getSrcUriTemplate();
    }

    @Override
    @JsonIgnore
    @Deprecated
    public int getLazyThreshold() {
        return 0;
    }

    @Override
    @JsonIgnore
    public int @NotNull [] getWidths() {
        return super.getWidths();
    }

    @Override
    @JsonIgnore
    public boolean isDmImage() {
        return super.isDmImage();
    }

    @Override
    @JsonIgnore
    @Deprecated
    public List<ImageArea> getAreas() {
        return super.getAreas();
    }

    @Override
    protected void initResource() {
        this.resource = Utils.getWrappedImageResourceWithInheritance(this.resource, this.linkHandler);
    }

    private Dimension getOriginalDimension() {
        Resource assetResource;
        ValueMap inheritedResourceProperties = this.resource.getValueMap();
        String inheritedFileReference = (String)inheritedResourceProperties.get("fileReference", String.class);
        String resizeWidth = (String)this.currentStyle.get("resizeWidth", String.class);
        if (StringUtils.isNotEmpty((CharSequence)inheritedFileReference) && (assetResource = this.request.getResourceResolver().getResource(inheritedFileReference)) != null) {
            Dimension dimension;
            Asset asset = (Asset)assetResource.adaptTo(Asset.class);
            EnhancedRendition original = null;
            if (asset != null) {
                original = new EnhancedRendition(asset.getOriginal());
            }
            if (original != null && (dimension = original.getDimension()) != null) {
                if (resizeWidth != null && Integer.parseInt(resizeWidth) > 0 && (double)Integer.parseInt(resizeWidth) < dimension.getWidth()) {
                    int calculatedHeight = (int)Math.round((double)Integer.parseInt(resizeWidth) * (dimension.getHeight() / (double)((float)dimension.getWidth())));
                    return new Dimension(Integer.parseInt(resizeWidth), calculatedHeight);
                }
                return dimension;
            }
        }
        return new Dimension(0, 0);
    }
}

