/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.models;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface HtmlPageItem {
    @Deprecated
    public static final String PN_ELEMENT = "element";
    @Deprecated
    public static final String PN_LOCATION = "location";
    @Deprecated
    public static final String NN_ATTRIBUTES = "attributes";
    public static final String PN_HREF = "href";
    public static final String PN_SRC = "src";

    default public Element getElement() {
        return null;
    }

    default public Location getLocation() {
        return null;
    }

    default public Map<String, String> getAttributes() {
        return null;
    }

    public static enum Element {
        SCRIPT("script"),
        LINK("link"),
        META("meta");

        private String name;

        private Element(String name) {
            this.name = name;
        }

        @Nullable
        public static Element fromString(String name) {
            for (Element element : Element.values()) {
                if (!StringUtils.equals((CharSequence)element.getName(), (CharSequence)name)) continue;
                return element;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public String[] getAttributeNames() {
            switch (this) {
                case LINK: {
                    return new String[]{"crossorigin", HtmlPageItem.PN_HREF, "hreflang", "media", "referrerpolicy", "rel", "sizes", "title", "type"};
                }
                case SCRIPT: {
                    return new String[]{"async", "charset", "defer", HtmlPageItem.PN_SRC, "type"};
                }
                case META: {
                    return new String[]{"charset", "content", "http-equiv", "name"};
                }
            }
            return new String[0];
        }

        @JsonValue
        public String toString() {
            return this.name;
        }
    }

    public static enum Location {
        HEADER("header"),
        FOOTER("footer");

        private String name;

        private Location(String name) {
            this.name = name;
        }

        @NotNull
        public static Location fromString(String name) {
            for (Location location : Location.values()) {
                if (!StringUtils.equals((CharSequence)location.getName(), (CharSequence)name)) continue;
                return location;
            }
            return HEADER;
        }

        public String getName() {
            return this.name;
        }

        @JsonValue
        public String toString() {
            return this.name;
        }
    }
}

