/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.commons.editor.dialog.inherited;

import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.models.Image;
import com.adobe.cq.wcm.core.components.models.Teaser;
import com.adobe.cq.wcm.core.components.util.ComponentUtils;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.factory.ModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
public class PageImageThumbnail {
    private static final Logger log = LoggerFactory.getLogger(PageImageThumbnail.class);
    @Self
    private SlingHttpServletRequest request;
    @SlingObject
    private ResourceResolver resourceResolver;
    @Inject
    private ModelFactory modelFactory;
    private String alt;
    private String src;
    private String componentPath;
    private String currentPagePath;
    private String configPath;

    @PostConstruct
    protected void initModel() {
        PageManager pageManager;
        this.configPath = this.request.getRequestPathInfo().getResourcePath();
        this.componentPath = this.request.getRequestPathInfo().getSuffix();
        if (StringUtils.isBlank((CharSequence)this.componentPath)) {
            RequestParameter itemParam = this.request.getRequestParameter("item");
            if (itemParam == null) {
                log.error("Suffix and 'item' param are blank");
                return;
            }
            this.componentPath = itemParam.getString();
        }
        if ((pageManager = (PageManager)this.resourceResolver.adaptTo(PageManager.class)) == null) {
            log.error("pagemanager is null");
            return;
        }
        Resource component = this.resourceResolver.getResource(this.componentPath);
        if (component == null) {
            log.error("the component at {} does not exist", (Object)this.componentPath);
            return;
        }
        Page currentPage = pageManager.getContainingPage(component);
        if (currentPage != null) {
            this.currentPagePath = currentPage.getPath();
        }
        Page targetPage = null;
        RequestParameter pageLinkParam = this.request.getRequestParameter("pageLink");
        if (pageLinkParam != null) {
            String pageLink = pageLinkParam.getString();
            targetPage = pageManager.getPage(pageLink);
        } else {
            Teaser teaserModel = (Teaser)this.modelFactory.getModelFromWrappedRequest(this.request, component, Teaser.class);
            Link link = null;
            if (teaserModel != null) {
                link = teaserModel.getLink();
            } else {
                Image imageModel = (Image)this.modelFactory.getModelFromWrappedRequest(this.request, component, Image.class);
                if (imageModel != null) {
                    link = imageModel.getImageLink();
                }
            }
            targetPage = link != null ? (Page)link.getReference() : currentPage;
        }
        if (targetPage == null) {
            log.info("A target page cannot be found for the link defined in the request parameter or on the server at {}.", (Object)component.getPath());
            return;
        }
        Resource featuredImage = ComponentUtils.getFeaturedImage(targetPage);
        if (featuredImage == null) {
            log.info("No featured image defined for the page at {}", (Object)targetPage.getPath());
            return;
        }
        Image imageModel = (Image)this.modelFactory.getModelFromWrappedRequest(this.request, featuredImage, Image.class);
        if (imageModel == null) {
            log.info("the image model of {} is null", (Object)featuredImage.getPath());
            return;
        }
        this.alt = imageModel.getAlt();
        this.src = imageModel.getSrc();
    }

    public String getAlt() {
        return this.alt;
    }

    public String getSrc() {
        return this.src;
    }

    public String getComponentPath() {
        return this.componentPath;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getCurrentPagePath() {
        return this.currentPagePath;
    }
}

