/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.link;

import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.internal.link.LinkImpl;
import com.adobe.cq.wcm.core.components.services.link.PathProcessor;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.designer.Style;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
public class LinkHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkHandler.class);
    public static final String HTML_EXTENSION = ".html";
    public static final String PN_DISABLE_SHADOWING = "disableShadowing";
    public static final boolean PROP_DISABLE_SHADOWING_DEFAULT = false;
    private static final Set<String> VALID_LINK_TARGETS = ImmutableSet.of((Object)"_blank", (Object)"_parent", (Object)"_top");
    @Self
    private SlingHttpServletRequest request;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    private ValueMap properties;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    private Style currentStyle;
    @ScriptVariable
    @Optional
    private PageManager pageManager;
    @OSGiService
    private List<PathProcessor> pathProcessors;
    private Boolean shadowingDisabled;

    @NotNull
    public java.util.Optional<Link> getLink(@NotNull Resource resource) {
        return this.getLink(resource, "linkURL");
    }

    @NotNull
    public java.util.Optional<Link> getLink(@NotNull Resource resource, String linkURLPropertyName) {
        ValueMap props = resource.getValueMap();
        String linkURL = (String)props.get(linkURLPropertyName, String.class);
        if (linkURL == null) {
            return java.util.Optional.empty();
        }
        String linkTarget = (String)props.get("linkTarget", String.class);
        String linkAccessibilityLabel = (String)props.get("linkAccessibilityLabel", String.class);
        String linkTitleAttribute = (String)props.get("linkTitleAttribute", String.class);
        return java.util.Optional.ofNullable(this.getLink(linkURL, linkTarget, linkAccessibilityLabel, linkTitleAttribute).orElse(null));
    }

    @NotNull
    public java.util.Optional<Link<Page>> getLink(@Nullable Page page) {
        if (page == null) {
            return java.util.Optional.empty();
        }
        Pair<Page, String> pair = this.resolvePage(page);
        return this.buildLink((String)pair.getRight(), this.request, (Page)pair.getLeft(), null);
    }

    @NotNull
    public java.util.Optional<Link<Page>> getLink(@Nullable String linkURL, @Nullable String target) {
        Pair<Page, String> pair = this.resolvePage(this.getPage(linkURL).orElse(null));
        linkURL = StringUtils.isNotEmpty((CharSequence)((CharSequence)pair.getRight())) ? (String)pair.getRight() : linkURL;
        String resolvedLinkURL = this.validateAndResolveLinkURL(linkURL);
        final String resolvedLinkTarget = this.validateAndResolveLinkTarget(target);
        return this.buildLink(resolvedLinkURL, this.request, (Page)pair.getLeft(), (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("target", resolvedLinkTarget);
            }
        });
    }

    @NotNull
    public java.util.Optional<Link<Page>> getLink(@Nullable String linkURL, @Nullable String target, @Nullable String linkAccessibilityLabel, @Nullable String linkTitleAttribute) {
        Pair<Page, String> pair = this.resolvePage(this.getPage(linkURL).orElse(null));
        linkURL = StringUtils.isNotEmpty((CharSequence)((CharSequence)pair.getRight())) ? (String)pair.getRight() : linkURL;
        String resolvedLinkURL = this.validateAndResolveLinkURL(linkURL);
        final String resolvedLinkTarget = this.validateAndResolveLinkTarget(target);
        final String validatedLinkAccessibilityLabel = this.validateLinkAccessibilityLabel(linkAccessibilityLabel);
        final String validatedLinkTitleAttribute = this.validateLinkTitleAttribute(linkTitleAttribute);
        return java.util.Optional.of(this.buildLink(resolvedLinkURL, this.request, (Page)pair.getLeft(), (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("target", resolvedLinkTarget);
                this.put("aria-label", validatedLinkAccessibilityLabel);
                this.put("title", validatedLinkTitleAttribute);
            }
        })).orElse(null);
    }

    private java.util.Optional<Link<Page>> buildLink(String path, SlingHttpServletRequest request, Page page, Map<String, String> htmlAttributes) {
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            return this.pathProcessors.stream().filter(pathProcessor -> pathProcessor.accepts(path, request)).findFirst().map(pathProcessor -> new LinkImpl<Page>(pathProcessor.sanitize(path, request), pathProcessor.map(path, request), pathProcessor.externalize(path, request), page, pathProcessor.processHtmlAttributes(path, htmlAttributes)));
        }
        return java.util.Optional.of(new LinkImpl<Page>(path, path, path, page, htmlAttributes));
    }

    @Nullable
    private String validateAndResolveLinkURL(String linkURL) {
        if (!StringUtils.isEmpty((CharSequence)linkURL)) {
            return this.getLinkURL(linkURL);
        }
        return null;
    }

    private String validateAndResolveLinkTarget(String linkTarget) {
        if (linkTarget != null && VALID_LINK_TARGETS.contains(linkTarget)) {
            return linkTarget;
        }
        return null;
    }

    private String validateLinkAccessibilityLabel(String linkAccessibilityLabel) {
        if (!StringUtils.isBlank((CharSequence)linkAccessibilityLabel)) {
            return linkAccessibilityLabel.trim();
        }
        return null;
    }

    private String validateLinkTitleAttribute(String linkTitleAttribute) {
        if (!StringUtils.isBlank((CharSequence)linkTitleAttribute)) {
            return linkTitleAttribute.trim();
        }
        return null;
    }

    @NotNull
    private String getLinkURL(@NotNull String path) {
        return this.getPage(path).map(this::getPageLinkURL).orElse(path);
    }

    @NotNull
    private String getPageLinkURL(@NotNull Page page) {
        return page.getPath() + HTML_EXTENSION;
    }

    @NotNull
    private java.util.Optional<Page> getPage(@Nullable String path) {
        if (this.pageManager == null) {
            this.pageManager = (PageManager)this.request.getResourceResolver().adaptTo(PageManager.class);
        }
        if (this.pageManager == null) {
            return java.util.Optional.empty();
        }
        return java.util.Optional.ofNullable(this.pageManager.getPage(path));
    }

    @NotNull
    private Pair<Page, String> resolvePage(@Nullable Page page) {
        Page resolved = page;
        String redirectTarget = null;
        String linkURL = null;
        if (!this.isShadowingDisabled()) {
            Pair<Page, String> pair = this.resolveRedirects(page);
            resolved = (Page)pair.getLeft();
            redirectTarget = (String)pair.getRight();
        }
        if (resolved == null) {
            if (StringUtils.isNotEmpty(redirectTarget)) {
                return new ImmutablePair((Object)page, redirectTarget);
            }
            resolved = page;
        }
        if (resolved != null) {
            linkURL = this.getPageLinkURL(resolved);
        }
        return new ImmutablePair((Object)resolved, (Object)linkURL);
    }

    @NotNull
    public Pair<Page, String> resolveRedirects(@Nullable Page page) {
        Page result = page;
        String redirectTarget = null;
        if (page != null && page.getPageManager() != null) {
            LinkedHashSet<String> redirectCandidates = new LinkedHashSet<String>();
            redirectCandidates.add(page.getPath());
            while (result != null && StringUtils.isNotEmpty((CharSequence)(redirectTarget = (String)result.getProperties().get("cq:redirectTarget", String.class)))) {
                result = page.getPageManager().getPage(redirectTarget);
                if (result == null || redirectCandidates.add(result.getPath())) continue;
                LOGGER.warn("Detected redirect loop for the following pages: {}.", redirectCandidates);
                break;
            }
        }
        return new ImmutablePair((Object)result, redirectTarget);
    }

    private boolean isShadowingDisabled() {
        if (this.shadowingDisabled == null) {
            this.shadowingDisabled = false;
            if (this.currentStyle != null) {
                this.shadowingDisabled = (Boolean)this.currentStyle.get(PN_DISABLE_SHADOWING, (Object)this.shadowingDisabled);
            }
            if (this.properties != null) {
                this.shadowingDisabled = (Boolean)this.properties.get(PN_DISABLE_SHADOWING, (Object)this.shadowingDisabled);
            }
        }
        return this.shadowingDisabled;
    }
}

