/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.link;

import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.internal.jackson.LinkHtmlAttributesSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class LinkImpl<T>
implements Link<T> {
    public static final String ATTR_HREF = "href";
    public static final String ATTR_TARGET = "target";
    public static final String ATTR_ARIA_LABEL = "aria-label";
    public static final String ATTR_TITLE = "title";
    private static final Set<String> ALLOWED_ATTRIBUTES = new HashSet<String>(){
        {
            this.add(LinkImpl.ATTR_TARGET);
            this.add(LinkImpl.ATTR_ARIA_LABEL);
            this.add(LinkImpl.ATTR_TITLE);
        }
    };
    private final String url;
    private final String mappedUrl;
    private final T reference;
    private final Map<String, String> htmlAttributes;
    private final String externalizedUrl;

    public LinkImpl(@Nullable String url, @Nullable String mappedUrl, @Nullable String externalizedUrl, @Nullable T reference, @Nullable Map<String, String> htmlAttributes) {
        this.url = url;
        this.mappedUrl = mappedUrl;
        this.externalizedUrl = externalizedUrl;
        this.reference = reference;
        this.htmlAttributes = LinkImpl.buildHtmlAttributes(url, htmlAttributes);
    }

    @Override
    public boolean isValid() {
        return this.url != null;
    }

    @Override
    @JsonIgnore
    @Nullable
    public String getURL() {
        return this.url;
    }

    @Override
    @JsonProperty(value="url")
    @Nullable
    public String getMappedURL() {
        return this.mappedUrl;
    }

    @Override
    @JsonIgnore
    @Nullable
    public String getExternalizedURL() {
        return this.externalizedUrl;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonSerialize(using=LinkHtmlAttributesSerializer.class)
    @JsonProperty(value="attributes")
    @NotNull
    public Map<String, String> getHtmlAttributes() {
        return this.htmlAttributes;
    }

    @Override
    @JsonIgnore
    @Nullable
    public T getReference() {
        return this.reference;
    }

    private static Map<String, String> buildHtmlAttributes(String linkURL, Map<String, String> htmlAttributes) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        if (linkURL != null) {
            attributes.put(ATTR_HREF, linkURL);
        }
        if (htmlAttributes != null) {
            Map<String, String> filteredAttributes = htmlAttributes.entrySet().stream().filter(e -> ALLOWED_ATTRIBUTES.contains(e.getKey()) && StringUtils.isNotEmpty((CharSequence)((CharSequence)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            attributes.putAll(filteredAttributes);
        }
        return ImmutableMap.copyOf(attributes);
    }
}

