/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.export.json.SlingModelFilter;
import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.internal.link.LinkHandler;
import com.adobe.cq.wcm.core.components.models.Container;
import com.adobe.cq.wcm.core.components.models.ListItem;
import com.adobe.cq.wcm.core.components.models.datalayer.ContainerData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.adobe.cq.wcm.core.components.util.AbstractComponentImpl;
import com.day.cq.wcm.api.TemplatedResource;
import com.day.cq.wcm.api.components.ComponentManager;
import com.day.cq.wcm.api.designer.Style;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.factory.ModelFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractContainerImpl
extends AbstractComponentImpl
implements Container {
    @Self
    protected LinkHandler linkHandler;
    @ScriptVariable(injectionStrategy=InjectionStrategy.OPTIONAL)
    @JsonIgnore
    @Nullable
    protected Style currentStyle;
    @OSGiService
    protected SlingModelFilter slingModelFilter;
    @OSGiService
    protected ModelFactory modelFactory;
    protected List<ListItem> items;
    protected List<Resource> childComponents;
    protected List<Resource> filteredChildComponents;
    protected Map<String, ? extends ComponentExporter> itemModels;
    private String[] exportedItemsOrder;
    private String backgroundStyle;

    @NotNull
    protected List<Resource> getChildren() {
        if (this.childComponents == null) {
            Resource effectiveResource = this.getEffectiveResource();
            this.childComponents = Optional.ofNullable(this.request.getResourceResolver().adaptTo(ComponentManager.class)).map(componentManager -> StreamSupport.stream(effectiveResource.getChildren().spliterator(), false).filter(res -> Objects.nonNull(componentManager.getComponentOfResource(res)))).orElseGet(Stream::empty).collect(Collectors.toList());
        }
        return this.childComponents;
    }

    @NotNull
    protected List<Resource> getFilteredChildren() {
        if (this.filteredChildComponents == null) {
            this.filteredChildComponents = new LinkedList<Resource>();
            this.slingModelFilter.filterChildResources(this.getChildren()).forEach(this.filteredChildComponents::add);
        }
        return this.filteredChildComponents;
    }

    @NotNull
    protected abstract List<? extends ListItem> readItems();

    private Optional<String> getBackgroundColor() {
        return Optional.ofNullable(this.currentStyle).filter(style -> (Boolean)style.get("backgroundColorEnabled", (Object)Boolean.FALSE)).flatMap(style -> Optional.ofNullable(this.resource.getValueMap().get("backgroundColor", String.class))).filter(StringUtils::isNotEmpty);
    }

    private Optional<String> getBackgroundImage() {
        return Optional.ofNullable(this.currentStyle).filter(style -> (Boolean)style.get("backgroundImageEnabled", (Object)Boolean.FALSE)).flatMap(style -> this.linkHandler.getLink(this.resource, "backgroundImageReference").map(Link::getURL)).filter(StringUtils::isNotEmpty);
    }

    @Override
    @JsonIgnore
    @NotNull
    public List<ListItem> getItems() {
        if (this.items == null) {
            this.items = this.readItems().stream().map(i -> i).collect(Collectors.toList());
        }
        return this.items;
    }

    @Override
    @Nullable
    public String getBackgroundStyle() {
        if (this.backgroundStyle == null) {
            StringBuilder styleBuilder = new StringBuilder();
            this.getBackgroundImage().ifPresent(image -> styleBuilder.append("background-image:url(").append((String)image).append(");background-size:cover;background-repeat:no-repeat;"));
            this.getBackgroundColor().ifPresent(color -> styleBuilder.append("background-color:").append((String)color).append(";"));
            this.backgroundStyle = styleBuilder.toString();
        }
        if (StringUtils.isEmpty((CharSequence)this.backgroundStyle)) {
            return null;
        }
        return this.backgroundStyle;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.resource.getResourceType();
    }

    @Override
    @NotNull
    public Map<String, ? extends ComponentExporter> getExportedItems() {
        if (this.itemModels == null) {
            this.itemModels = this.getItemModels(this.request, ComponentExporter.class);
        }
        return this.itemModels;
    }

    @Override
    @NotNull
    public String[] getExportedItemsOrder() {
        if (this.exportedItemsOrder == null) {
            Map<String, ? extends ComponentExporter> models = this.getExportedItems();
            this.exportedItemsOrder = !models.isEmpty() ? models.keySet().toArray(ArrayUtils.EMPTY_STRING_ARRAY) : ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return Arrays.copyOf(this.exportedItemsOrder, this.exportedItemsOrder.length);
    }

    protected Map<String, ComponentExporter> getItemModels(@NotNull SlingHttpServletRequest request, @NotNull Class<ComponentExporter> modelClass) {
        LinkedHashMap<String, ComponentExporter> models = new LinkedHashMap<String, ComponentExporter>();
        this.getFilteredChildren().forEach(child -> {
            ComponentExporter model = (ComponentExporter)this.modelFactory.getModelFromWrappedRequest(request, child, modelClass);
            if (model != null) {
                models.put(child.getName(), model);
            }
        });
        return models;
    }

    @NotNull
    protected Resource getEffectiveResource() {
        if (this.resource instanceof TemplatedResource) {
            return this.resource;
        }
        return Optional.ofNullable((Resource)this.resource.adaptTo(TemplatedResource.class)).orElse(Optional.ofNullable((Resource)this.request.adaptTo(TemplatedResource.class)).orElse(this.resource));
    }

    @Override
    @NotNull
    protected ContainerData getComponentData() {
        return DataLayerBuilder.extending(super.getComponentData()).asContainer().withShownItems(this::getDataLayerShownItems).build();
    }

    @JsonIgnore
    public abstract String[] getDataLayerShownItems();
}

