/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.internal.link.LinkHandler;
import com.adobe.cq.wcm.core.components.internal.models.v1.LanguageNavigationItemImpl;
import com.adobe.cq.wcm.core.components.models.LanguageNavigation;
import com.adobe.cq.wcm.core.components.models.LanguageNavigationItem;
import com.adobe.cq.wcm.core.components.models.NavigationItem;
import com.adobe.cq.wcm.core.components.util.AbstractComponentImpl;
import com.day.cq.commons.Filter;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageFilter;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.designer.Style;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={LanguageNavigation.class, ComponentExporter.class}, resourceType={"core/wcm/components/languagenavigation/v1/languagenavigation"})
@Exporter(name="jackson", extensions={"json"})
public class LanguageNavigationImpl
extends AbstractComponentImpl
implements LanguageNavigation {
    public static final String RESOURCE_TYPE = "core/wcm/components/languagenavigation/v1/languagenavigation";
    private static final String PN_ACCESSIBILITY_LABEL = "accessibilityLabel";
    @Self
    private SlingHttpServletRequest request;
    @ScriptVariable
    private Page currentPage;
    @ScriptVariable
    private ValueMap properties;
    @ScriptVariable
    private Style currentStyle;
    @Self
    private LinkHandler linkHandler;
    @Nullable
    private String accessibilityLabel;
    private String navigationRoot;
    private int structureDepth;
    private Page rootPage;
    private List<NavigationItem> items;
    private int startLevel;

    @PostConstruct
    private void initModel() {
        this.navigationRoot = (String)this.properties.get("navigationRoot", this.currentStyle.get("navigationRoot", String.class));
        this.structureDepth = (Integer)this.properties.get("structureDepth", this.currentStyle.get("structureDepth", (Object)1));
    }

    @Override
    public List<NavigationItem> getItems() {
        if (this.items == null) {
            PageManager pageManager = this.currentPage.getPageManager();
            this.rootPage = pageManager.getPage(this.navigationRoot);
            if (this.rootPage != null) {
                int rootPageLevel = this.rootPage.getDepth();
                this.startLevel = rootPageLevel + 1;
                this.structureDepth += rootPageLevel;
                this.items = this.getItems(this.rootPage);
            } else {
                this.items = Collections.emptyList();
            }
        }
        return Collections.unmodifiableList(this.items);
    }

    @Override
    @Nullable
    public String getAccessibilityLabel() {
        if (this.accessibilityLabel == null) {
            this.accessibilityLabel = (String)this.resource.getValueMap().get(PN_ACCESSIBILITY_LABEL, String.class);
        }
        return this.accessibilityLabel;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.request.getResource().getResourceType();
    }

    private List<NavigationItem> getItems(Page root) {
        ArrayList<NavigationItem> pages = new ArrayList<NavigationItem>();
        if (root.getDepth() < this.structureDepth) {
            Iterator it = root.listChildren((Filter)new PageFilter());
            while (it.hasNext()) {
                Page page = (Page)it.next();
                boolean active = this.currentPage.getPath().equals(page.getPath()) || this.currentPage.getPath().startsWith(page.getPath() + "/");
                String title = page.getNavigationTitle();
                if (title == null) {
                    title = page.getTitle();
                }
                List<NavigationItem> children = this.getItems(page);
                int level = page.getDepth() - this.startLevel;
                Page localizedPage = this.getLocalizedPage(this.currentPage, page);
                if (localizedPage != null) {
                    page = localizedPage;
                }
                boolean current = this.currentPage.getPath().equals(page.getPath());
                pages.add(this.newLanguageNavigationItem(page, active, current, this.linkHandler, level, children, title, this.getId(), this.component));
            }
        }
        return pages;
    }

    protected LanguageNavigationItem newLanguageNavigationItem(Page page, boolean active, boolean current, @NotNull LinkHandler linkHandler, int level, List<NavigationItem> children, String title, String parentId, Component component) {
        return new LanguageNavigationItemImpl(page, active, current, linkHandler, level, children, title, parentId, component);
    }

    private Page getLocalizedPage(Page page, Page languageRoot) {
        Page localizedPage;
        String path = languageRoot.getPath();
        String relativePath = page.getPath();
        if (relativePath.startsWith(path)) {
            localizedPage = page;
        } else {
            String separator = "/";
            int i = relativePath.indexOf(separator);
            int occurrence = StringUtils.countMatches((CharSequence)path, (CharSequence)separator) + 1;
            while (--occurrence > 0 && i != -1) {
                i = relativePath.indexOf(separator, i + 1);
            }
            relativePath = i > 0 ? relativePath.substring(i) : "";
            path = path.concat(relativePath);
            PageManager pageManager = page.getPageManager();
            localizedPage = pageManager.getPage(path);
        }
        return localizedPage;
    }
}

