/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.internal.link.LinkHandler;
import com.adobe.cq.wcm.core.components.internal.models.v1.AbstractListItemImpl;
import com.adobe.cq.wcm.core.components.models.ListItem;
import com.adobe.cq.wcm.core.components.models.datalayer.PageData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.PageDataBuilder;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.components.Component;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Calendar;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PageListItemImpl
extends AbstractListItemImpl
implements ListItem {
    protected Page page;
    protected Optional<Link<Page>> link;

    public PageListItemImpl(@NotNull LinkHandler linkHandler, @NotNull Page page, String parentId, Component component) {
        super(parentId, page.getContentResource(), component);
        this.parentId = parentId;
        this.link = linkHandler.getLink(page);
        this.page = this.link.isPresent() ? this.link.get().getReference() : page;
    }

    @Override
    @JsonIgnore
    @Nullable
    public Link<Page> getLink() {
        return this.link.orElse(null);
    }

    @Override
    public String getURL() {
        return this.link.map(Link::getURL).orElse(null);
    }

    @Override
    public String getTitle() {
        return PageListItemImpl.getTitle(this.page);
    }

    public static String getTitle(@NotNull Page page) {
        String title = page.getNavigationTitle();
        if (title == null) {
            title = page.getPageTitle();
        }
        if (title == null) {
            title = page.getTitle();
        }
        if (title == null) {
            title = page.getName();
        }
        return title;
    }

    @Override
    public String getDescription() {
        return this.page.getDescription();
    }

    @Override
    public Calendar getLastModified() {
        return this.page.getLastModified();
    }

    @Override
    public String getPath() {
        return this.page.getPath();
    }

    @Override
    @JsonIgnore
    public String getName() {
        return this.page.getName();
    }

    @Override
    @NotNull
    protected PageData getComponentData() {
        return ((PageDataBuilder)((PageDataBuilder)DataLayerBuilder.extending(super.getComponentData()).asPage().withTitle(this::getTitle)).withLinkUrl(() -> this.link.map(Link::getMappedURL).orElse(null))).build();
    }
}

