/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.internal.Heading;
import com.adobe.cq.wcm.core.components.internal.link.LinkHandler;
import com.adobe.cq.wcm.core.components.internal.models.v1.AbstractImageDelegatingModel;
import com.adobe.cq.wcm.core.components.internal.models.v1.AbstractListItemImpl;
import com.adobe.cq.wcm.core.components.models.Image;
import com.adobe.cq.wcm.core.components.models.ListItem;
import com.adobe.cq.wcm.core.components.models.Teaser;
import com.adobe.cq.wcm.core.components.models.datalayer.ComponentData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.ComponentDataBuilder;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.adobe.cq.wcm.core.components.util.ComponentUtils;
import com.day.cq.commons.LabeledResource;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.designer.Style;
import com.day.text.Text;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.apache.sling.models.factory.ModelFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Teaser.class, ComponentExporter.class}, resourceType={"core/wcm/components/teaser/v1/teaser"})
@Exporter(name="jackson", extensions={"json"})
public class TeaserImpl
extends AbstractImageDelegatingModel
implements Teaser {
    public static final String RESOURCE_TYPE = "core/wcm/components/teaser/v1/teaser";
    private String pretitle;
    private String title;
    private String description;
    private String titleType;
    protected Page targetPage;
    private String imageSrc;
    protected boolean actionsEnabled = false;
    protected boolean titleHidden = false;
    private boolean showTitleType = false;
    protected boolean descriptionHidden = false;
    private boolean imageLinkHidden = false;
    private boolean pretitleHidden = false;
    private boolean titleLinkHidden = false;
    protected boolean titleFromPage = false;
    protected boolean descriptionFromPage = false;
    private List<Action> actions;
    protected final List<String> hiddenImageResourceProperties = new ArrayList<String>(){
        {
            this.add("jcr:title");
            this.add("jcr:description");
        }
    };
    protected final Map<String, String> overriddenImageResourceProperties = new HashMap<String, String>();
    protected Optional<Link> link;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Nullable
    protected String linkTarget;
    @ScriptVariable
    private Component component;
    @ScriptVariable
    protected PageManager pageManager;
    @ScriptVariable
    protected Style currentStyle;
    @OSGiService
    private ModelFactory modelFactory;
    @Self
    protected LinkHandler linkHandler;

    @PostConstruct
    protected void initModel() {
        this.initProperties();
        this.initImage();
        this.initLink();
    }

    protected void initProperties() {
        ValueMap properties = this.resource.getValueMap();
        this.pretitleHidden = (Boolean)this.currentStyle.get("pretitleHidden", (Object)this.pretitleHidden);
        this.titleHidden = (Boolean)this.currentStyle.get("titleHidden", (Object)this.titleHidden);
        this.descriptionHidden = (Boolean)this.currentStyle.get("descriptionHidden", (Object)this.descriptionHidden);
        this.titleType = (String)this.currentStyle.get("titleType", (Object)this.titleType);
        this.showTitleType = (Boolean)this.currentStyle.get("showTitleType", (Object)this.showTitleType);
        this.imageLinkHidden = (Boolean)this.currentStyle.get("imageLinkHidden", (Object)this.imageLinkHidden);
        this.titleLinkHidden = (Boolean)this.currentStyle.get("titleLinkHidden", (Object)this.titleLinkHidden);
        if (this.imageLinkHidden) {
            this.hiddenImageResourceProperties.add("linkURL");
        }
        this.actionsEnabled = (Boolean)this.currentStyle.get("actionsDisabled", (Object)((Boolean)properties.get("actionsEnabled", (Object)this.actionsEnabled) == false ? 1 : 0)) == false;
        this.titleFromPage = (Boolean)properties.get("titleFromPage", (Object)this.titleFromPage);
        this.descriptionFromPage = (Boolean)properties.get("descriptionFromPage", (Object)this.descriptionFromPage);
    }

    protected void initImage() {
        if (this.hasImage()) {
            this.setImageResource(this.component, this.request.getResource(), this.hiddenImageResourceProperties, this.overriddenImageResourceProperties);
        }
    }

    protected void initLink() {
        this.link = this.getTargetPage().map(page -> Optional.of(this.linkHandler.getLink(page.getPath(), this.linkTarget).orElse(null))).orElseGet(() -> {
            if (this.isActionsEnabled()) {
                return this.getActions().stream().findFirst().map(action -> Optional.ofNullable(this.linkHandler.getLink(action.getURL(), null).orElse(null))).orElse(Optional.empty());
            }
            return Optional.ofNullable(this.linkHandler.getLink(this.resource, "linkURL").orElse(null));
        });
    }

    protected boolean hasImage() {
        return Optional.ofNullable(this.resource.getValueMap().get("fileReference", String.class)).map(arg_0 -> ((ResourceResolver)this.request.getResourceResolver()).getResource(arg_0)).orElseGet(() -> this.request.getResource().getChild("file")) != null;
    }

    protected Action newAction(Resource actionRes, Component component) {
        return new Action(actionRes, this.getId(), component);
    }

    @Override
    public boolean isActionsEnabled() {
        return this.actionsEnabled;
    }

    @NotNull
    protected Optional<Page> getTargetPage() {
        if (this.targetPage == null) {
            this.targetPage = this.isActionsEnabled() ? (Page)this.getTeaserActions().stream().findFirst().flatMap(Action::getCtaPage).orElse(null) : (Page)Optional.ofNullable(this.resource.getValueMap().get("linkURL", String.class)).map(arg_0 -> ((PageManager)this.pageManager).getPage(arg_0)).orElse(null);
        }
        return Optional.ofNullable(this.targetPage);
    }

    @NotNull
    protected List<Action> getTeaserActions() {
        if (this.actions == null) {
            this.actions = Optional.ofNullable(this.isActionsEnabled() ? this.resource.getChild("actions") : null).map(Resource::getChildren).map(Iterable::spliterator).map(s -> StreamSupport.stream(s, false)).orElseGet(Stream::empty).map(action -> this.newAction((Resource)action, this.component)).collect(Collectors.toList());
        }
        return this.actions;
    }

    @Override
    public List<ListItem> getActions() {
        return Collections.unmodifiableList(this.getTeaserActions());
    }

    @Override
    public String getLinkURL() {
        return this.link.map(Link::getURL).orElse(null);
    }

    @JsonProperty(value="imagePath")
    @Nullable
    public String getImagePath() {
        if (this.imageSrc == null) {
            this.imageSrc = Optional.ofNullable(this.getImageResource()).map(imageResource -> (Image)this.modelFactory.getModelFromWrappedRequest(this.request, imageResource, Image.class)).map(Image::getSrc).orElse(null);
        }
        return this.imageSrc;
    }

    @Override
    public boolean isImageLinkHidden() {
        return this.imageLinkHidden;
    }

    @Override
    public String getTitle() {
        if (this.title == null && !this.titleHidden) {
            this.title = this.titleFromPage ? this.getTargetPage().map(tp -> (String)StringUtils.defaultIfEmpty((CharSequence)tp.getPageTitle(), (CharSequence)tp.getTitle())).orElseGet(() -> this.getTeaserActions().stream().findFirst().map(Action::getTitle).orElse(null)) : (String)this.resource.getValueMap().get("jcr:title", String.class);
        }
        return this.title;
    }

    @Override
    public String getPretitle() {
        if (this.pretitle == null && !this.pretitleHidden) {
            this.pretitle = (String)this.resource.getValueMap().get("pretitle", String.class);
        }
        return this.pretitle;
    }

    @Override
    public boolean isTitleLinkHidden() {
        return this.titleLinkHidden;
    }

    @Override
    public String getDescription() {
        if (this.description == null && !this.descriptionHidden) {
            this.description = this.descriptionFromPage ? (String)this.getTargetPage().map(LabeledResource::getDescription).map(Text::escapeXml).orElse(null) : (String)this.resource.getValueMap().get("jcr:description", String.class);
        }
        return this.description;
    }

    @Override
    public String getTitleType() {
        Heading heading;
        if (this.showTitleType) {
            this.titleType = (String)this.resource.getValueMap().get("titleType", (Object)this.titleType);
        }
        if ((heading = Heading.getHeading(this.titleType)) != null) {
            return heading.getElement();
        }
        return null;
    }

    @Override
    @NotNull
    public String getExportedType() {
        return this.request.getResource().getResourceType();
    }

    @Override
    @NotNull
    protected ComponentData getComponentData() {
        return ((ComponentDataBuilder)((ComponentDataBuilder)((ComponentDataBuilder)DataLayerBuilder.extending(super.getComponentData()).asComponent().withTitle(this::getTitle)).withLinkUrl(() -> this.link.map(Link::getMappedURL).orElse(this.getLinkURL()))).withDescription(this::getDescription)).build();
    }

    @JsonIgnoreProperties(value={"path", "description", "lastModified", "name", "ctaPage"})
    public class Action
    extends AbstractListItemImpl
    implements ListItem {
        private static final String CTA_ID_PREFIX = "cta";
        @NotNull
        private final Resource ctaResource;
        protected final String ctaTitle;
        protected final Optional<Link<Page>> ctaLink;
        private final String ctaParentId;
        private String ctaId;

        public Action(Resource actionRes, String parentId, Component component) {
            super(parentId, actionRes, component);
            this.ctaParentId = parentId;
            this.ctaResource = actionRes;
            ValueMap ctaProperties = actionRes.getValueMap();
            this.ctaTitle = (String)ctaProperties.get("text", String.class);
            this.ctaLink = Optional.ofNullable(TeaserImpl.this.linkHandler.getLink(actionRes, "link").orElse(null));
            if (component != null) {
                this.dataLayerType = component.getResourceType() + "/" + CTA_ID_PREFIX;
            }
        }

        @Override
        @JsonIgnore
        @Nullable
        public Link getLink() {
            return this.ctaLink.orElse(null);
        }

        @NotNull
        public Optional<Page> getCtaPage() {
            return Optional.ofNullable(this.ctaLink.map(Link::getReference).orElse(null));
        }

        @Override
        @Nullable
        public String getTitle() {
            return this.ctaTitle;
        }

        @Override
        @Nullable
        public String getPath() {
            Page page = this.ctaLink.map(Link::getReference).orElse(null);
            if (page != null) {
                return page.getPath();
            }
            return this.ctaLink.map(Link::getURL).orElse(null);
        }

        @Override
        @Nullable
        public String getURL() {
            return this.ctaLink.map(Link::getURL).orElse(null);
        }

        @Override
        public String getId() {
            if (this.ctaId == null) {
                this.ctaId = Optional.ofNullable(this.ctaResource.getValueMap().get("id", String.class)).filter(StringUtils::isNotEmpty).map(id -> StringUtils.replace((String)StringUtils.normalizeSpace((String)StringUtils.trim((String)id)), (String)" ", (String)"-")).orElseGet(() -> ComponentUtils.generateId(StringUtils.join((Object[])new String[]{this.ctaParentId, "-", CTA_ID_PREFIX}), this.ctaResource.getPath()));
            }
            return this.ctaId;
        }
    }
}

