/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v1.embeddable;

import com.adobe.cq.wcm.core.components.models.datalayer.EmbeddableData;
import com.adobe.cq.wcm.core.components.models.datalayer.builder.DataLayerBuilder;
import com.adobe.cq.wcm.core.components.models.embeddable.YouTube;
import com.adobe.cq.wcm.core.components.util.AbstractComponentImpl;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.api.policies.ContentPolicy;
import com.day.cq.wcm.api.policies.ContentPolicyManager;
import com.day.cq.wcm.commons.policy.ContentPolicyStyle;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={YouTube.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class YouTubeImpl
extends AbstractComponentImpl
implements YouTube {
    private static final String BASE_EMBED_URL = "https://www.youtube.com/embed/%s";
    private static final String PARAMETER_ORIGIN = "origin";
    private static final String PARAMETER_MUTE = "mute";
    private static final String PARAMETER_LOOP = "loop";
    private static final String PARAMETER_AUTOPLAY = "autoplay";
    private static final String PARAMETER_REL = "rel";
    private static final String PARAMETER_PLAYS_INLINE = "playsinline";
    private static final String PARAMETER_PLAYLIST = "playlist";
    private static final String PARAMETER_LANGUAGE = "hl";
    private static final Logger LOGGER = LoggerFactory.getLogger(YouTubeImpl.class);
    @ValueMapValue(name="youtubeVideoId")
    @Nullable
    private String videoId;
    @ValueMapValue(name="youtubeWidth")
    @Nullable
    private String iFrameWidth;
    @ValueMapValue(name="youtubeHeight")
    @Nullable
    private String iFrameHeight;
    @ValueMapValue(name="youtubeAspectRatio")
    @Nullable
    private String iFrameAspectRatio;
    @ValueMapValue(name="layout")
    @Nullable
    private String layout;
    @ValueMapValue(name="youtubeMute")
    @Nullable
    private Boolean isMute;
    @ValueMapValue(name="youtubeAutoPlay")
    @Nullable
    private Boolean isAutoPlay;
    @ValueMapValue(name="youtubeLoop")
    @Nullable
    private Boolean isLoop;
    @ValueMapValue(name="youtubeRel")
    @Nullable
    private Boolean isRel;
    @ValueMapValue(name="youtubePlaysInline")
    @Nullable
    private Boolean isPlaysInline;
    @ScriptVariable(injectionStrategy=InjectionStrategy.REQUIRED)
    private Page currentPage;
    @ScriptVariable(injectionStrategy=InjectionStrategy.REQUIRED)
    private ComponentContext componentContext;
    @Self
    private SlingHttpServletRequest request;

    @Override
    public boolean isEmpty() {
        return StringUtils.isBlank((CharSequence)this.videoId);
    }

    @Override
    @Nullable
    public String getIFrameWidth() {
        return this.iFrameWidth;
    }

    @Override
    @Nullable
    public String getIFrameHeight() {
        return this.iFrameHeight;
    }

    @Override
    @Nullable
    public String getIFrameAspectRatio() {
        return this.iFrameAspectRatio;
    }

    @Override
    @Nullable
    public String getLayout() {
        return this.layout;
    }

    @Nullable
    private static Resource getWrappedResource(Resource resource) {
        if (resource instanceof ResourceWrapper) {
            return ((ResourceWrapper)ResourceWrapper.class.cast(resource)).getResource();
        }
        return null;
    }

    Style getStyleForWrappedResource(Resource resource) {
        ContentPolicyManager policyManager = (ContentPolicyManager)resource.getResourceResolver().adaptTo(ContentPolicyManager.class);
        if (policyManager != null) {
            Resource wrappedResource = YouTubeImpl.getWrappedResource(resource);
            if (wrappedResource != null) {
                ContentPolicy currentPolicy = policyManager.getPolicy(wrappedResource, this.request);
                if (currentPolicy != null) {
                    return new ContentPolicyStyle(currentPolicy, this.componentContext.getCell());
                }
                LOGGER.debug("No policy found for wrapped resource {}", (Object)wrappedResource);
            } else {
                LOGGER.debug("The current resource is not a wrapped resource: {}", (Object)resource);
            }
        } else {
            LOGGER.debug("Could not get ContentPolicyManager from resource resolver. Probably service not running!");
        }
        return null;
    }

    @Override
    @Nullable
    public String getIFrameSrc() throws URISyntaxException {
        Optional<URI> uri = this.getIFrameSrc(this.getStyleForWrappedResource(this.request.getResource()));
        if (!uri.isPresent()) {
            return null;
        }
        return uri.get().toString();
    }

    @Override
    @NotNull
    protected EmbeddableData getComponentData() {
        return DataLayerBuilder.extending(super.getComponentData()).asEmbeddable().withEmbeddableDetails(() -> ImmutableMap.of((Object)"youtubeVideoId", (Object)this.videoId)).build();
    }

    Optional<URI> getIFrameSrc(Style currentStyle) throws URISyntaxException {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        URIBuilder uriBuilder = new URIBuilder(String.format(BASE_EMBED_URL, this.videoId));
        StringBuffer requestURL = this.request.getRequestURL();
        String currentProtocolHostandPort = requestURL.substring(0, requestURL.length() - this.request.getPathInfo().length());
        uriBuilder.addParameter(PARAMETER_ORIGIN, currentProtocolHostandPort);
        uriBuilder.addParameter(PARAMETER_LANGUAGE, this.currentPage.getLanguage().toString());
        if (currentStyle != null) {
            if (Boolean.TRUE.equals(currentStyle.get("youtubeMuteEnabled", (Object)false))) {
                this.addYouTubeBooleanUriParameter(uriBuilder, PARAMETER_MUTE, this.isMute, currentStyle, "youtubeMuteDefaultValue");
            }
            if (Boolean.TRUE.equals(currentStyle.get("youtubeAutoPlayEnabled", (Object)false))) {
                if (this.componentContext.getParent().getEditContext() == null) {
                    this.addYouTubeBooleanUriParameter(uriBuilder, PARAMETER_AUTOPLAY, this.isAutoPlay, currentStyle, "youtubeAutoPlayDefaultValue");
                } else {
                    LOGGER.debug("Autoplay disabled because WCMMode is not disabled");
                }
            }
            if (Boolean.TRUE.equals(currentStyle.get("youtubeLoopEnabled", (Object)false)) && this.addYouTubeBooleanUriParameter(uriBuilder, PARAMETER_LOOP, this.isLoop, currentStyle, "youtubeLoopDefaultValue")) {
                uriBuilder.addParameter(PARAMETER_PLAYLIST, this.videoId);
            }
            if (Boolean.TRUE.equals(currentStyle.get("youtubeRelatedVideosEnabled", (Object)false))) {
                this.addYouTubeBooleanUriParameter(uriBuilder, PARAMETER_REL, this.isRel, currentStyle, "youtubeRelatedVideosDefaultValue");
            }
            if (Boolean.TRUE.equals(currentStyle.get("youtubePlaysInlineEnabled", (Object)false))) {
                this.addYouTubeBooleanUriParameter(uriBuilder, PARAMETER_PLAYS_INLINE, this.isPlaysInline, currentStyle, "youtubePlaysInlineDefaultValue");
            }
        } else {
            LOGGER.debug("No style available, optional YouTube parameters are not used!");
        }
        return Optional.of(uriBuilder.build());
    }

    boolean getBooleanValueOrDefaultFromStyle(Boolean value, Style style, String stylePropertyName) {
        if (value == null) {
            return (Boolean)style.get(stylePropertyName, (Object)false);
        }
        return value;
    }

    boolean addYouTubeBooleanUriParameter(URIBuilder uriBuilder, String parameterName, Boolean value, Style style, String stylePropertyName) {
        boolean effectiveValue = this.getBooleanValueOrDefaultFromStyle(value, style, stylePropertyName);
        uriBuilder.addParameter(parameterName, effectiveValue ? "1" : "0");
        return effectiveValue;
    }
}

