/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v2;

import com.adobe.aem.wcm.seo.SeoTags;
import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.export.json.ContainerExporter;
import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.config.HtmlPageItemConfig;
import com.adobe.cq.wcm.core.components.config.HtmlPageItemsConfig;
import com.adobe.cq.wcm.core.components.internal.link.LinkHandler;
import com.adobe.cq.wcm.core.components.internal.models.v1.RedirectItemImpl;
import com.adobe.cq.wcm.core.components.internal.models.v2.HtmlPageItemImpl;
import com.adobe.cq.wcm.core.components.models.HtmlPageItem;
import com.adobe.cq.wcm.core.components.models.NavigationItem;
import com.adobe.cq.wcm.core.components.models.Page;
import com.adobe.granite.license.ProductInfoProvider;
import com.adobe.granite.ui.clientlibs.ClientLibrary;
import com.adobe.granite.ui.clientlibs.HtmlLibraryManager;
import com.adobe.granite.ui.clientlibs.LibraryType;
import com.day.cq.wcm.api.components.ComponentContext;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.caconfig.ConfigurationBuilder;
import org.apache.sling.caconfig.ConfigurationResolver;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.Version;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Page.class, ContainerExporter.class}, resourceType={"core/wcm/components/page/v2/page"})
@Exporter(name="jackson", extensions={"json"})
public class PageImpl
extends com.adobe.cq.wcm.core.components.internal.models.v1.PageImpl
implements Page {
    protected static final String RESOURCE_TYPE = "core/wcm/components/page/v2/page";
    protected static final String PN_CLIENTLIBS_JS_HEAD = "clientlibsJsHead";
    public static final String PN_REDIRECT_TARGET = "cq:redirectTarget";
    public static final String PN_MAIN_CONTENT_SELECTOR_PROP = "mainContentSelector";
    public static final String PN_STYLE_RENDER_ALTERNATE_LANGUAGE_LINKS = "renderAlternateLanguageLinks";
    public static final String ROBOTS_TAG_NOINDEX = "noindex";
    private Boolean hasCloudconfigSupport;
    @OSGiService
    private HtmlLibraryManager htmlLibraryManager;
    @OSGiService
    private ProductInfoProvider productInfoProvider;
    @OSGiService
    private ConfigurationResourceResolver configurationResourceResolver;
    @OSGiService
    private ConfigurationResolver configurationResolver;
    @ScriptVariable
    private ComponentContext componentContext;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL, name="cq:redirectTarget")
    @Nullable
    private String redirectTargetValue;
    @Self
    private LinkHandler linkHandler;
    private String appResourcesPath;
    private NavigationItem redirectTarget;
    private String[] clientLibCategoriesJsBody;
    private String[] clientLibCategoriesJsHead;
    private List<HtmlPageItem> htmlPageItems;
    private Map<Locale, String> alternateLanguageLinks;
    private String canonicalUrl;
    private List<String> robotsTags;

    @Override
    @PostConstruct
    protected void initModel() {
        super.initModel();
        this.appResourcesPath = Optional.ofNullable(this.currentStyle).map(style -> (String)style.get("appResourcesClientlib", String.class)).map(resourcesClientLibrary -> this.htmlLibraryManager.getLibraries(new String[]{resourcesClientLibrary}, LibraryType.CSS, true, false)).map(Collection::stream).orElse(Stream.empty()).findFirst().map(this::getProxyPath).orElse(null);
    }

    protected NavigationItem newRedirectItem(@NotNull String redirectTarget, @NotNull SlingHttpServletRequest request, @NotNull LinkHandler linkHandler) {
        return new RedirectItemImpl(redirectTarget, request, linkHandler);
    }

    private String getProxyPath(ClientLibrary lib) {
        String path = lib.getPath();
        if (lib.allowProxy()) {
            for (String searchPath : this.request.getResourceResolver().getSearchPath()) {
                if (!path.startsWith(searchPath)) continue;
                path = this.request.getContextPath() + "/etc.clientlibs/" + path.replaceFirst(searchPath, "");
            }
        } else if (this.request.getResourceResolver().getResource(lib.getPath()) == null) {
            path = null;
        }
        if (path != null) {
            path = path + "/resources";
        }
        return path;
    }

    @Override
    protected void loadFavicons(String designPath) {
    }

    @Override
    @JsonIgnore
    @Deprecated
    public Map<String, String> getFavicons() {
        throw new UnsupportedOperationException();
    }

    @Override
    @JsonIgnore
    public String[] getClientLibCategoriesJsBody() {
        if (this.clientLibCategoriesJsBody == null) {
            List<String> headLibs = Arrays.asList(this.getClientLibCategoriesJsHead());
            this.clientLibCategoriesJsBody = (String[])Arrays.stream(this.clientLibCategories).distinct().filter(item -> !headLibs.contains(item)).toArray(String[]::new);
        }
        return Arrays.copyOf(this.clientLibCategoriesJsBody, this.clientLibCategoriesJsBody.length);
    }

    @Override
    @JsonIgnore
    public String[] getClientLibCategoriesJsHead() {
        if (this.clientLibCategoriesJsHead == null) {
            this.clientLibCategoriesJsHead = (String[])Optional.ofNullable(this.currentStyle).map(style -> (String[])style.get(PN_CLIENTLIBS_JS_HEAD, String[].class)).map(Arrays::stream).orElseGet(Stream::empty).distinct().toArray(String[]::new);
        }
        return Arrays.copyOf(this.clientLibCategoriesJsHead, this.clientLibCategoriesJsHead.length);
    }

    @Override
    public String getAppResourcesPath() {
        return this.appResourcesPath;
    }

    @Override
    public String getCssClassNames() {
        Set cssClassesSet = this.componentContext.getCssClassNames();
        return StringUtils.join((Iterable)cssClassesSet, (String)" ");
    }

    @Override
    @NotNull
    public String[] getExportedItemsOrder() {
        return super.getExportedItemsOrder();
    }

    @Override
    @NotNull
    public Map<String, ? extends ComponentExporter> getExportedItems() {
        return super.getExportedItems();
    }

    @Override
    @Nullable
    public NavigationItem getRedirectTarget() {
        if (this.redirectTarget == null && StringUtils.isNotEmpty((CharSequence)this.redirectTargetValue)) {
            this.redirectTarget = this.newRedirectItem(this.redirectTargetValue, this.request, this.linkHandler);
        }
        return this.redirectTarget;
    }

    @Override
    public boolean hasCloudconfigSupport() {
        if (this.hasCloudconfigSupport == null) {
            this.hasCloudconfigSupport = this.productInfoProvider == null || this.productInfoProvider.getProductInfo() == null || this.productInfoProvider.getProductInfo().getVersion() == null ? Boolean.valueOf(false) : Boolean.valueOf(this.productInfoProvider.getProductInfo().getVersion().compareTo(new Version("6.4.0")) >= 0);
        }
        return this.hasCloudconfigSupport;
    }

    @Override
    public String getMainContentSelector() {
        if (this.currentStyle != null) {
            return (String)this.currentStyle.get(PN_MAIN_CONTENT_SELECTOR_PROP, String.class);
        }
        return null;
    }

    @Override
    @NotNull
    public List<HtmlPageItem> getHtmlPageItems() {
        if (this.htmlPageItems == null) {
            Resource configResource;
            HtmlPageItemImpl item;
            this.htmlPageItems = new LinkedList<HtmlPageItem>();
            ConfigurationBuilder configurationBuilder = this.configurationResolver.get(this.resource);
            HtmlPageItemsConfig config = (HtmlPageItemsConfig)configurationBuilder.as(HtmlPageItemsConfig.class);
            for (HtmlPageItemConfig itemConfig : config.items()) {
                item = new HtmlPageItemImpl(StringUtils.defaultString((String)config.prefixPath()), itemConfig);
                if (item.getElement() == null) continue;
                this.htmlPageItems.add(item);
            }
            if (this.htmlPageItems.isEmpty() && (configResource = this.configurationResourceResolver.getResource(this.resource, "sling:configs", HtmlPageItemsConfig.class.getName())) != null) {
                ValueMap properties = configResource.getValueMap();
                for (Resource child : configResource.getChildren()) {
                    item = new HtmlPageItemImpl((String)properties.get("prefixPath", (Object)""), child);
                    if (item.getElement() == null) continue;
                    this.htmlPageItems.add(item);
                }
            }
        }
        return this.htmlPageItems;
    }

    @Override
    @Nullable
    public String getCanonicalLink() {
        if (this.canonicalUrl == null) {
            String canonicalUrl;
            try {
                SeoTags seoTags = (SeoTags)this.resource.adaptTo(SeoTags.class);
                canonicalUrl = seoTags != null ? seoTags.getCanonicalUrl() : null;
            }
            catch (NoClassDefFoundError ex) {
                canonicalUrl = null;
            }
            if (!this.getRobotsTags().contains(ROBOTS_TAG_NOINDEX)) {
                this.canonicalUrl = canonicalUrl != null ? canonicalUrl : (String)this.linkHandler.getLink(this.currentPage).map(Link::getExternalizedURL).orElse(null);
            }
        }
        return this.canonicalUrl;
    }

    @Override
    @NotNull
    public Map<Locale, String> getAlternateLanguageLinks() {
        if (this.alternateLanguageLinks == null) {
            try {
                SeoTags seoTags;
                this.alternateLanguageLinks = this.currentStyle != null && ((Boolean)this.currentStyle.get(PN_STYLE_RENDER_ALTERNATE_LANGUAGE_LINKS, (Object)Boolean.FALSE)).booleanValue() ? ((seoTags = (SeoTags)this.resource.adaptTo(SeoTags.class)) != null && seoTags.getAlternateLanguages().size() > 0 ? Collections.unmodifiableMap(seoTags.getAlternateLanguages()) : Collections.emptyMap()) : Collections.emptyMap();
            }
            catch (NoClassDefFoundError ex) {
                this.alternateLanguageLinks = Collections.emptyMap();
            }
        }
        return this.alternateLanguageLinks;
    }

    @Override
    @NotNull
    public List<String> getRobotsTags() {
        if (this.robotsTags == null) {
            try {
                SeoTags seoTags = (SeoTags)this.resource.adaptTo(SeoTags.class);
                this.robotsTags = seoTags != null && seoTags.getRobotsTags().size() > 0 ? Collections.unmodifiableList(seoTags.getRobotsTags()) : Collections.emptyList();
            }
            catch (NoClassDefFoundError ex) {
                this.robotsTags = Collections.emptyList();
            }
        }
        return this.robotsTags;
    }
}

