/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.models.v2;

import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.commons.link.Link;
import com.adobe.cq.wcm.core.components.internal.Utils;
import com.adobe.cq.wcm.core.components.internal.models.v1.TeaserImpl;
import com.adobe.cq.wcm.core.components.models.Teaser;
import com.day.cq.commons.LabeledResource;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.Component;
import com.day.text.Text;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Teaser.class, ComponentExporter.class}, resourceType={"core/wcm/components/teaser/v2/teaser"})
@Exporter(name="jackson", extensions={"json"})
public class TeaserImpl
extends com.adobe.cq.wcm.core.components.internal.models.v1.TeaserImpl {
    public static final String RESOURCE_TYPE = "core/wcm/components/teaser/v2/teaser";
    private String title;
    private String description;
    @ScriptVariable
    protected Page currentPage;

    @Override
    protected void initProperties() {
        this.titleFromPage = true;
        this.descriptionFromPage = true;
        this.actionsEnabled = true;
        super.initProperties();
    }

    @Override
    protected void initImage() {
        this.overriddenImageResourceProperties.put("linkURL", this.getTargetPage().map(Page::getPath).orElse(null));
        this.overriddenImageResourceProperties.put("actionsEnabled", Boolean.valueOf(this.actionsEnabled).toString());
        if (StringUtils.isNotEmpty((CharSequence)this.getTitle()) || this.getTeaserActions().size() > 0) {
            this.overriddenImageResourceProperties.put("imageLinkHidden", Boolean.TRUE.toString());
        }
        super.initImage();
    }

    @Override
    protected void initLink() {
        this.link = this.linkHandler.getLink(this.resource, "linkURL");
    }

    @Override
    @Nullable
    public Link getLink() {
        return this.link.orElse(null);
    }

    @Override
    @JsonIgnore
    @Deprecated
    public String getLinkURL() {
        return super.getLinkURL();
    }

    @Override
    @NotNull
    protected Optional<Page> getTargetPage() {
        if (this.targetPage == null) {
            String linkURL = (String)this.resource.getValueMap().get("linkURL", String.class);
            this.targetPage = StringUtils.isNotEmpty((CharSequence)linkURL) ? (Page)Optional.ofNullable(this.resource.getValueMap().get("linkURL", String.class)).map(arg_0 -> ((PageManager)this.pageManager).getPage(arg_0)).orElse(null) : (this.actionsEnabled && this.getActions().size() > 0 ? (Page)this.getTeaserActions().stream().findFirst().flatMap(TeaserImpl.Action::getCtaPage).orElse(null) : this.currentPage);
        }
        return Optional.ofNullable(this.targetPage);
    }

    @Override
    public String getTitle() {
        if (this.title == null && !this.titleHidden) {
            this.title = this.titleFromPage ? this.getTargetPage().map(tp -> (String)StringUtils.defaultIfEmpty((CharSequence)tp.getPageTitle(), (CharSequence)tp.getTitle())).orElseGet(() -> this.getTeaserActions().stream().findFirst().map(TeaserImpl.Action::getTitle).orElseGet(() -> Optional.ofNullable(this.getCurrentPage()).map(cp -> (String)StringUtils.defaultIfEmpty((CharSequence)cp.getPageTitle(), (CharSequence)cp.getTitle())).orElse(null))) : (String)this.resource.getValueMap().get("jcr:title", String.class);
        }
        return this.title;
    }

    @Override
    public String getDescription() {
        if (this.description == null && !this.descriptionHidden) {
            this.description = this.descriptionFromPage ? (String)this.getTargetPage().map(Optional::of).orElseGet(() -> Optional.ofNullable(this.getCurrentPage())).map(LabeledResource::getDescription).map(Text::escapeXml).orElse(null) : (String)this.resource.getValueMap().get("jcr:description", String.class);
        }
        return this.description;
    }

    @Override
    protected boolean hasImage() {
        Resource wrappedResource = Utils.getWrappedImageResourceWithInheritance(this.resource, this.linkHandler, this.currentStyle, this.currentPage);
        return Optional.ofNullable(wrappedResource.getValueMap().get("fileReference", String.class)).map(arg_0 -> ((ResourceResolver)this.request.getResourceResolver()).getResource(arg_0)).orElseGet(() -> wrappedResource.getChild("file")) != null;
    }

    @Override
    protected Action newAction(Resource actionRes, Component component) {
        return new Action(actionRes, this.getId(), component);
    }

    public class Action
    extends TeaserImpl.Action {
        public Action(Resource actionRes, String parentId, Component component) {
            super(actionRes, parentId, component);
        }

        @Override
        @JsonIgnore(value=false)
        @Nullable
        public Link getLink() {
            return super.getLink();
        }

        @Override
        @JsonIgnore
        @Deprecated
        @Nullable
        public String getURL() {
            return super.getURL();
        }
    }
}

