/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.services.embed;

import com.adobe.cq.wcm.core.components.internal.services.embed.OEmbedClientImplConfigurationFactory;
import com.adobe.cq.wcm.core.components.internal.services.embed.OEmbedJSONResponseImpl;
import com.adobe.cq.wcm.core.components.internal.services.embed.OEmbedXMLResponseImpl;
import com.adobe.cq.wcm.core.components.services.embed.OEmbedClient;
import com.adobe.cq.wcm.core.components.services.embed.OEmbedResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.osgi.services.HttpClientBuilderFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Component(service={OEmbedClient.class})
public class OEmbedClientImpl
implements OEmbedClient {
    @Reference
    private HttpClientBuilderFactory httpClientBuilderFactory;
    private int soTimeout = 60000;
    private int connectionTimeout = 5000;
    private static final Logger LOGGER = LoggerFactory.getLogger(OEmbedClientImpl.class);
    private Map<String, OEmbedClientImplConfigurationFactory.Config> configs = new HashMap<String, OEmbedClientImplConfigurationFactory.Config>();
    private ObjectMapper mapper = new ObjectMapper();
    private static JAXBContext jaxbContext;

    @Override
    public String getProvider(String url) {
        OEmbedClientImplConfigurationFactory.Config config;
        if (StringUtils.isNotEmpty((CharSequence)url) && (config = this.getConfiguration(url)) != null) {
            return config.provider();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OEmbedResponse getResponse(String url) {
        OEmbedClientImplConfigurationFactory.Config config = this.getConfiguration(url);
        if (config == null) {
            return null;
        }
        if (OEmbedResponse.Format.JSON == OEmbedResponse.Format.fromString(config.format())) {
            try {
                String jsonURL = this.buildURL(config.endpoint(), url, OEmbedResponse.Format.JSON.getValue(), null, null);
                return (OEmbedResponse)this.mapper.readValue(this.getData(jsonURL), OEmbedJSONResponseImpl.class);
            }
            catch (IOException ioex) {
                LOGGER.error("Failed to read JSON response", (Throwable)ioex);
                return null;
            }
        }
        if (jaxbContext == null) return null;
        if (OEmbedResponse.Format.XML != OEmbedResponse.Format.fromString(config.format())) return null;
        try {
            String xmlURL = this.buildURL(config.endpoint(), url, OEmbedResponse.Format.XML.getValue(), null, null);
            try (InputStream xmlStream = this.getData(xmlURL);){
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                SAXSource xmlSource = new SAXSource(spf.newSAXParser().getXMLReader(), new InputSource(xmlStream));
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                OEmbedResponse oEmbedResponse = (OEmbedResponse)jaxbUnmarshaller.unmarshal((Source)xmlSource);
                return oEmbedResponse;
            }
        }
        catch (IOException | JAXBException | ParserConfigurationException | SAXException e) {
            LOGGER.error("Failed to read JSON response", e);
        }
        return null;
    }

    @Override
    public boolean isUnsafeContext(String url) {
        OEmbedClientImplConfigurationFactory.Config config;
        if (StringUtils.isNotEmpty((CharSequence)url) && (config = this.getConfiguration(url)) != null) {
            return config.unsafeContext();
        }
        return false;
    }

    protected OEmbedClientImplConfigurationFactory.Config getConfiguration(String url) {
        if (!StringUtils.isEmpty((CharSequence)url)) {
            for (OEmbedClientImplConfigurationFactory.Config config : this.configs.values()) {
                for (String scheme : config.scheme()) {
                    if (!Pattern.matches(scheme, url)) continue;
                    return config;
                }
            }
        }
        return null;
    }

    protected InputStream getData(String url) throws IOException {
        RequestConfig rc = RequestConfig.custom().setConnectTimeout(this.connectionTimeout).setSocketTimeout(this.soTimeout).build();
        CloseableHttpClient httpClient = this.httpClientBuilderFactory != null && this.httpClientBuilderFactory.newBuilder() != null ? this.httpClientBuilderFactory.newBuilder().setDefaultRequestConfig(rc).build() : HttpClients.custom().setDefaultRequestConfig(rc).build();
        HttpResponse response = httpClient.execute((HttpUriRequest)new HttpGet(url));
        return response.getEntity().getContent();
    }

    protected String buildURL(String endpoint, String url, String format, Integer maxWidth, Integer maxHeight) throws MalformedURLException {
        StringBuilder sb = new StringBuilder(endpoint);
        String separator = endpoint.contains("?") ? "&" : "?";
        this.addURLParameter(sb, separator, "url", url);
        separator = "&";
        this.addURLParameter(sb, separator, "format", format);
        this.addURLParameter(sb, separator, "maxwidth", maxWidth);
        this.addURLParameter(sb, separator, "maxheight", maxHeight);
        return sb.toString();
    }

    protected void addURLParameter(StringBuilder sb, String separator, String name, Object value) {
        if (sb != null && StringUtils.isNotEmpty((CharSequence)separator) && StringUtils.isNotEmpty((CharSequence)name) && value != null) {
            sb.append(separator).append(name).append("=").append(value);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, updated="bindOEmbedClientImplConfigurationFactory")
    protected void bindOEmbedClientImplConfigurationFactory(OEmbedClientImplConfigurationFactory configurationFactory, Map<String, ?> properties) {
        String key = (String)properties.get("service.pid");
        this.configs.put(key, configurationFactory.getConfig());
    }

    protected void unbindOEmbedClientImplConfigurationFactory(OEmbedClientImplConfigurationFactory configurationFactory, Map<String, ?> properties) {
        String key = (String)properties.get("service.pid");
        this.configs.remove(key, configurationFactory.getConfig());
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{OEmbedXMLResponseImpl.class});
        }
        catch (JAXBException e) {
            LOGGER.error("Failed to retrieve JAXBContext", (Throwable)e);
        }
    }
}

