/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.servlets;

import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.msm.api.LiveRelationship;
import com.day.cq.wcm.msm.api.LiveRelationshipManager;
import java.io.IOException;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=POST", "sling.servlet.resourceTypes=core/wcm/components/panelcontainer/v1/panelcontainer", "sling.servlet.selectors=container", "sling.servlet.extensions=html"})
public class ContainerServlet
extends SlingAllMethodsServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerServlet.class);
    protected static final String SELECTOR = "container";
    protected static final String EXTENSION = "html";
    private static final String PARAM_DELETED_CHILDREN = "delete";
    private static final String PARAM_ORDERED_CHILDREN = "order";
    private static final String RT_GHOST = "wcm/msm/components/ghost";
    @Reference
    private transient LiveRelationshipManager liveRelationshipManager;

    protected void doPost(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        ResourceResolver resolver = request.getResourceResolver();
        Resource container = request.getResource();
        try {
            String[] deletedChildrenNames = request.getParameterValues(PARAM_DELETED_CHILDREN);
            if (deletedChildrenNames != null && deletedChildrenNames.length > 0) {
                for (String childName : deletedChildrenNames) {
                    Resource child = container.getChild(childName);
                    if (child == null) continue;
                    LiveRelationship liveRelationship = this.liveRelationshipManager.getLiveRelationship(child, false);
                    if (liveRelationship != null && liveRelationship.getStatus().isSourceExisting()) {
                        this.liveRelationshipManager.cancelRelationship(resolver, liveRelationship, true, false);
                        Resource parent = child.getParent();
                        String name = child.getName();
                        resolver.delete(child);
                        if (parent == null) continue;
                        this.createGhost(parent, name, resolver);
                        continue;
                    }
                    resolver.delete(child);
                }
            }
            resolver.commit();
        }
        catch (WCMException | RepositoryException | PersistenceException e) {
            LOGGER.error("Could not delete items of the container at {}", (Object)container.getPath(), (Object)e);
            response.sendError(500);
        }
        try {
            Node containerNode;
            String[] orderedChildrenNames = request.getParameterValues(PARAM_ORDERED_CHILDREN);
            if (orderedChildrenNames != null && orderedChildrenNames.length > 0 && (containerNode = (Node)container.adaptTo(Node.class)) != null) {
                int i;
                for (i = 0; i < orderedChildrenNames.length; ++i) {
                    if (containerNode.hasNode(orderedChildrenNames[i])) continue;
                    containerNode.addNode(orderedChildrenNames[i]);
                }
                for (i = orderedChildrenNames.length - 1; i >= 0; --i) {
                    if (i == orderedChildrenNames.length - 1) {
                        containerNode.orderBefore(orderedChildrenNames[i], null);
                        continue;
                    }
                    containerNode.orderBefore(orderedChildrenNames[i], orderedChildrenNames[i + 1]);
                }
                resolver.commit();
            }
        }
        catch (RepositoryException | PersistenceException e) {
            LOGGER.error("Could not order items of the container at {}", (Object)container.getPath(), (Object)e);
            response.sendError(500);
        }
    }

    private void createGhost(@NotNull Resource parent, String name, ResourceResolver resolver) throws PersistenceException, RepositoryException, WCMException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("jcr:primaryType", "nt:unstructured");
        properties.put("sling:resourceType", RT_GHOST);
        resolver.create(parent, name, properties);
    }
}

