/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.commons.editor.dialog.childreneditor;

import com.adobe.cq.wcm.core.components.commons.editor.dialog.childreneditor.Item;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
public class Editor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Editor.class);
    @Self
    private SlingHttpServletRequest request;
    private Resource container;
    private List<Item> items;

    @PostConstruct
    private void initModel() {
        this.readChildren();
    }

    private void readChildren() {
        this.items = new ArrayList<Item>();
        String containerPath = this.request.getRequestPathInfo().getSuffix();
        if (StringUtils.isNotEmpty((CharSequence)containerPath)) {
            ResourceResolver resolver = this.request.getResourceResolver();
            this.container = resolver.getResource(containerPath);
            if (this.container != null) {
                ComponentManager componentManager = (ComponentManager)this.request.getResourceResolver().adaptTo(ComponentManager.class);
                for (Resource resource : this.container.getChildren()) {
                    Component component;
                    if (resource == null || (component = componentManager.getComponentOfResource(resource)) == null) continue;
                    this.items.add(new Item(this.request, resource));
                }
            }
        }
    }

    public List<Item> getItems() {
        return this.items;
    }

    public Resource getContainer() {
        return this.container;
    }
}

