/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.form;

import com.adobe.cq.wcm.core.components.internal.form.FormConstants;
import com.adobe.cq.wcm.core.components.models.form.Button;
import com.day.cq.wcm.foundation.forms.FormStructureHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.scripting.api.resource.ScriptingResourceResolverProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={FormStructureHelper.class})
public class FormStructureHelperImpl
implements FormStructureHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)FormStructureHelperImpl.class.getName());
    @Reference
    private ScriptingResourceResolverProvider scriptingResourceResolverProvider;

    public Resource getFormResource(Resource resource) {
        if (resource == null || StringUtils.equals((CharSequence)resource.getPath(), (CharSequence)"/")) {
            return null;
        }
        for (String resourceType : FormConstants.RT_ALL_CORE_FORM_CONTAINER) {
            if (!resource.isResourceType(resourceType)) continue;
            return resource;
        }
        return this.getFormResource(resource.getParent());
    }

    public Iterable<Resource> getFormElements(Resource resource) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        if (this.isFormContainer(resource)) {
            for (Resource child : resource.getChildren()) {
                this.filterFormElements(child, list);
            }
        }
        return list;
    }

    private boolean isFormContainer(Resource resource) {
        for (String resourceType : FormConstants.RT_ALL_CORE_FORM_CONTAINER) {
            if (!resource.isResourceType(resourceType)) continue;
            return true;
        }
        return false;
    }

    private void filterFormElements(Resource resource, List<Resource> list) {
        if (this.isFormResource(resource) && !this.isButtonElement(resource)) {
            list.add(resource);
        } else {
            for (Resource child : resource.getChildren()) {
                this.filterFormElements(child, list);
            }
        }
    }

    private boolean isButtonElement(Resource resource) {
        ValueMap valueMap;
        if ((resource.isResourceType("core/wcm/components/form/button/v1/button") || resource.isResourceType("core/wcm/components/form/button/v2/button")) && (valueMap = (ValueMap)resource.adaptTo(ValueMap.class)) != null) {
            String type = (String)valueMap.get("type", String.class);
            if (StringUtils.equalsIgnoreCase((CharSequence)Button.Type.SUBMIT.name(), (CharSequence)type)) {
                return true;
            }
        }
        return false;
    }

    private boolean isFormResource(Resource resource) {
        if (resource.getResourceType().startsWith("core/wcm/components/form/")) {
            return true;
        }
        if (this.scriptingResourceResolverProvider != null) {
            ResourceResolver scriptResourceResolver = this.scriptingResourceResolverProvider.getRequestScopedResourceResolver();
            if (this.ifFormResourceSuperType(scriptResourceResolver, resource)) {
                return true;
            }
        } else {
            LOGGER.warn("Unable to get reference of ScriptingResourceResolverProvider. Couldn't check search path of {} ", (Object)resource.getPath());
        }
        return false;
    }

    private boolean ifFormResourceSuperType(ResourceResolver scriptResourceResolver, Resource resource) {
        boolean result = false;
        Resource componentResource = scriptResourceResolver.getResource(resource.getResourceType());
        String parentResourceType = scriptResourceResolver.getParentResourceType(componentResource);
        while (!result && parentResourceType != null) {
            if (parentResourceType.startsWith("core/wcm/components/form/")) {
                result = true;
                continue;
            }
            parentResourceType = scriptResourceResolver.getParentResourceType(parentResourceType);
        }
        return result;
    }

    public boolean canManage(Resource resource) {
        return this.getFormResource(resource) != null;
    }

    public Resource updateFormStructure(Resource formResource) {
        if (formResource != null && this.isFormContainer(formResource)) {
            ModifiableValueMap formProperties = (ModifiableValueMap)formResource.adaptTo(ModifiableValueMap.class);
            if (formProperties != null) {
                if (formProperties.get("actionType", String.class) == null) {
                    formProperties.put((Object)"actionType", (Object)"foundation/components/form/actions/store");
                    String defaultContentPath = "/content/usergenerated" + formResource.getPath().replaceAll("^.content", "").replaceAll("jcr.content.*", "") + "cq-gen" + System.currentTimeMillis() + "/";
                    formProperties.put((Object)"action", (Object)defaultContentPath);
                }
            } else {
                LOGGER.error("Resource is not adaptable to ValueMap - unable to add default action type and form id for " + formResource);
            }
        }
        return null;
    }
}

