/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.internal.jackson;

import com.day.cq.wcm.api.Page;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PageSerializer
extends StdSerializer<Page> {
    static final String JSON_KEY_NAME = "name";
    static final String JSON_KEY_TITLE = "title";
    static final String JSON_KEY_PAGE_TITLE = "pageTitle";
    static final String JSON_KEY_PATH = "path";
    static final String JSON_KEY_DESCRIPTION = "description";

    public PageSerializer() {
        this(null);
    }

    public PageSerializer(Class<Page> t) {
        super(t);
    }

    public void serialize(Page page, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        Map<String, String> pageProperties = this.getPageProperties(page);
        jsonGenerator.writeStartObject();
        for (Map.Entry<String, String> entry : pageProperties.entrySet()) {
            jsonGenerator.writeStringField(entry.getKey(), entry.getValue());
        }
        jsonGenerator.writeEndObject();
    }

    private Map<String, String> getPageProperties(Page page) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(JSON_KEY_NAME, page.getName());
        properties.put(JSON_KEY_TITLE, page.getTitle());
        properties.put(JSON_KEY_PAGE_TITLE, page.getPageTitle());
        properties.put(JSON_KEY_PATH, page.getPath());
        properties.put(JSON_KEY_DESCRIPTION, page.getDescription());
        return properties;
    }
}

